/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include "replay.h"

replay::replay(record & r, bool _verbose) : 
	rec(r), verbose(_verbose), g_world(NULL, *this, r.creature_type), gameon(true), frame_num(0)
{
}

int replay::eval()
{
	while(gameon) {
		record::frame & fr = rec.get_next_frame(frame_num);
		for(record::action_it it = fr.actions.begin(); it != fr.actions.end(); it++) {
			action &ac = *it;

			sf::Vector2f mouse(ac.x, ac.y);
			
			switch(ac.t) {
				case action::none:
				break;
				case action::cast_spell:
				{
					std::vector<spell> &spells = g_world.get_selected()->get_spells();
					if(spells.size() <= ac.id) {
						if(verbose)
							std::cerr << "Invalid spell id: " << ac.id << std::endl;
						break;
					}

					spell & cur_spell = g_world.get_selected()->get_spells()[ac.id];
					g_world.cast(g_world.get_selected(), cur_spell, mouse);
				}
				break;
				case action::select:
					g_world.select(mouse);
				break;
				case action::move_player:
					g_world.move_player(mouse);
				break;
				case action::cc_tree_selection:
					g_world.cc_tree_selection(mouse);
				break;
				case action::select_id:
					g_world.select(ac.id);
				break;
				default:
				break;
			}
		}

		g_world.update(game_time);
		game_time.step();
		frame_num++;
	}

	return 0;
}

void replay::hit(object *src, object *target, attack &atk) { }

void replay::grow(mushroom *m, mushroom::mushroom_type t) 
{ 
	if(verbose) {
		std::cout << "Mushroom (" << m->get_x() << ", " << m->get_y() << 
			"): grew to " << m->type_string() << std::endl;
	}
}

void replay::die(object *obj)
{
	mushroom *m;
	ant *a;
	if(verbose) {
		if((m = dynamic_cast<mushroom*>(obj))) {
			std::cout << "Mushroom (" << m->get_x() << ", " << m->get_y() << ", " << m->type_string() << ") died" << std::endl;
		} else if((a = dynamic_cast<ant*>(obj))) {
			std::cout << "Ant (" << a->get_x() << ", " << a->get_y() << ") died" << std::endl;
		} else {
			std::cout << "Something was destryoed" << std::endl;
		}
	}
}

void replay::spawn(object *obj) 
{ 
	mushroom *m;
	ant *a;
	if(verbose) {
		if((m = dynamic_cast<mushroom*>(obj))) {
			std::cout << "Mushroom (" << m->get_x() << ", " << m->get_y() << ", " << m->type_string() << ") spawned" << std::endl;
		} else if((a = dynamic_cast<ant*>(obj))) {
			std::cout << "Ant (" << a->get_x() << ", " << a->get_y() << ") spawned" << std::endl;
		} else {
			std::cout << "Something was created" << std::endl;
		}
	}
}

void replay::ding(object *obj) 
{ 
	if(verbose) {
		std::cout << "Ding!\n";
	}
}

void replay::win() 
{
	if(gameon) {
		if(verbose) {
			std::cout << "Game won at : " << game_time.get_time() << std::endl;
		}
		std::cout << creature::names[rec.creature_type] << " " << game_time.get_time() << std::endl;
		gameon = false;
	}
}

void replay::lose() 
{ 
	if(verbose) {
		std::cout << "Game lost at : " << game_time.get_time() << std::endl;
	} else {
		throw rec_exception("Game lost!");
	}
	gameon = false;
}

void replay::wind_blow()
{

}

void replay::trap_trigger(trap *, ant *)
{

}
