/***************************************************************************
*   Copyright (C) 2010 by
*    Santtu Keskinen <laquendi@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _SBOX_H
#define _SBOX_H

#include "gui.h"
#include "spell.h"
#include "sbutton.h"
#include "creature.h"
#include "mushroom.h"
#include "commandcenter.h"
#include <vector>

class world;

class button_widget : public Gui::VerticalList {
	public:
	 	button_widget(bool show_hotkey);
		void update(world &w);
		void selected_change(world &w);
		bool get_spell(Gui::ID button_id, spell &spell);
	private:
		std::vector<sbutton*> spell_buttons;
};

class sbox : public Gui::Container {
	public:
		sbox(Gui::Rect rect, bool show_hotkey);
		
		void update(world &w);
		
		bool get_spell(Gui::ID button_id, spell &_spell);

		void hide_tabs();
	
		void init_creature_tab();
		void init_mushroom_tab();
		void init_cc_tab();
		void init_ant_tab();
		void init_heap_tab();

		void view_creature_tab(world &w);
		void view_mushroom_tab(world &w);
		void view_cc_tab(world &w);
		void view_ant_tab(world &w);
		void view_heap_tab(world &w);

	private:
		Gui::Container *creature_tab, *mushroom_tab, *cc_tab, *ant_tab, *heap_tab;
		
		button_widget *m_buttons;
		button_widget *cc_buttons;
		button_widget *c_buttons;

		Gui::VerticalList *m_v_list;
		Gui::TextLabel *m_type;
		Gui::TextLabel *m_hp; 
		Gui::TextLabel *m_energy; 
		Gui::TextLabel *m_str;
		Gui::TextLabel *m_mana;
		Gui::TextLabel *m_dur;
		
		Gui::VerticalList *cc_v_list;
		Gui::TextLabel *cc_hp;
		Gui::TextLabel *cc_energy;

		Gui::VerticalList *c_v_list;
		Gui::TextLabel *c_kills;
		Gui::TextLabel *c_casts;
		Gui::TextLabel *c_m;
		Gui::TextLabel *c_dead_m;
		Gui::TextLabel *c_wind;

		Gui::VerticalList *a_v_list;
		Gui::TextLabel *a_level;
		Gui::TextLabel *a_hp;

		Gui::VerticalList *h_v_list;
		Gui::TextLabel *h_waves;
		Gui::TextLabel *h_num;
		Gui::TextLabel *h_level;
		Gui::TextLabel *h_min;
		Gui::TextLabel *h_max;

		bool show_hotkey;

		static const int list_top;
		static const int list_left;
};

#endif

