/***************************************************************************
*   Copyright (C) 2010 by
*    Santtu Keskinen <laquendi@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include "sbutton.h"
#include "world.h"


sf::Image dummy;
bool dummy_loaded = false;
const sf::Image& dummy_image()
{
	if(!dummy_loaded) {
		dummy.LoadFromFile("gfx/dummy.png");
		dummy_loaded = true;
	}
	return dummy;
}

sbutton::sbutton(bool _show_hotkey) : Gui::ImgButton(dummy_image()), p_spell(NULL),
	show_hotkey(_show_hotkey)
{
	SetW(32);
	SetH(32);
	SetBorderWidth(0);
}

void sbutton::set_to_dummy()
{
	SetImage(dummy_image());
	p_spell = NULL;
}

void sbutton::update(world &w)
{
	if(p_spell &&  p_spell->available(w.get_selected(), w)) 
		SetEnabled(true);
	else
		SetEnabled(false);
	if(p_spell)
		SetToolTip(p_spell->get_desc(w.get_selected(), show_hotkey), sf::Color::Black, sf::Color(0x30, 0x30, 0x70));
}

void sbutton::change_spell(const sf::Image &img, spell &_spell, selectable *caster)
{
	SetImage(img);
	SetW(32);
	SetH(32);
	p_spell = &_spell;
	SetToolTip(p_spell->get_desc(caster, show_hotkey), sf::Color::Black, sf::Color(0x30, 0x30, 0x70));
	SetEnabled(true);
}

void sbutton::Render(sf::RenderTarget &target) const
{
	if(p_spell) {
		ImgButton::Render(target);
		float phase = p_spell->get_cooldown_phase();

		Gui::Rect rect = GetRect();
		rect.x += 2;
		rect.y += 2;
		rect.h -= 2;
		rect.w -= 2;

		if(!IsEnabled())
			Gui::drawFilledRectangle(target, rect, 1, sf::Color(0, 0, 0, 150));
		Gui::drawFilledRectangle(target, rect, phase, sf::Color(0, 0, 0, 150));
	}
}

