/***************************************************************************
*   Copyright (C) 2010 by
*    Santtu Keskinen <laquendi@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _SELECTABLE_H
#define _SELECTABLE_H

#include "animation.h"
#include "object.h"
#include "spell.h"

class selectable : public object {
	public:
		selectable() : object() {}
		selectable(animation_data *anim_data);
		virtual ~selectable() {}
		bool ok() { return true; }
		virtual std::vector<spell> &get_spells() { return spells; }
		virtual void pause();
		virtual void update(world &w);
		void calc_spell_ids() {
			for(size_t a = 0; a < spells.size(); a++)
				spells[a].set_id(a);
		}
	protected:
		std::vector<spell> spells;
};

#endif

