/***************************************************************************
*   Copyright (C) 2010 by
*    Mika Isojärvi <bungler29@gmail.com>
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include "soundplayer.h"
#include "settings.h"

sound_delay::sound_delay(sf::Sound* _s, double _delay) : 
	s(_s), delay(_delay), started(false) 
{ }

void sound_delay::update()
{
	if(!started && delay <= clock.get_time()) {
		started = true;
		s->Play();
	}
}

void sound_delay::pause()
{
	clock.pause();
	s->Pause();
}

void sound_delay::unpause()
{
	clock.unpause();
	s->Play();
}

soundplayer::soundplayer(){
	volume = 75.0f;

	load("wind", "sounds/Wind-SoundBible.com-950807958.ogg");
	load("ant_attack", "sounds/Dragon Bite-SoundBible.com-1625781385.ogg");
	load("mushroom_grow", "sounds/Slime-SoundBible.com-803762203.ogg");
	load("trap_trigger", "sounds/Tank Firing-SoundBible.com-998264747.ogg");
	load("explosion", "sounds/Grenade Explosion-SoundBible.com-2100581469.ogg");
	load("mushroom_attack", "sounds/Slime Splash-SoundBible.com-1894179558.ogg");
	load("magic_wand", "sounds/Magic Wand Noise-SoundBible.com-375928671.ogg");
	load("ding", "sounds/Bell Sound Ring-SoundBible.com-181681426.ogg");
	load("hit_wall", "sounds/Pin Or Ting Metal Plate-SoundBible.com-1105716472.ogg");
	load("mushroom_attack_wall", "sounds/Flame Arrow-SoundBible.com-618067908.ogg");
	load("axe_swing", "sounds/Battle Axe Swing-SoundBible.com-1901696187.ogg");
}

void soundplayer::load(std::string name, std::string file)
{
	sf::SoundBuffer *tmp_sb = new sf::SoundBuffer;
	if(!tmp_sb->LoadFromFile(file)) {
		delete tmp_sb;
		return;
	}
	sound_buffers[name] = tmp_sb;
}

soundplayer::~soundplayer()
{
	for(std::map<std::string, sf::SoundBuffer*>::iterator i = sound_buffers.begin(); i != sound_buffers.end(); i++){
		delete i->second;
	}
}

bool soundplayer::play_sound(std::string name, bool loop, double delay)
{
	std::map<std::string, sf::SoundBuffer*>::iterator i;
	i = sound_buffers.find(name);
	if(i == sound_buffers.end()){
		return false;
	} else {
		sf::Sound * sound = new sf::Sound();
		sound->SetBuffer(*(i->second));
		sound->SetLoop(loop);
		sound->SetVolume(volume);
		playing_sounds.insert(std::make_pair(name, sound_delay(sound, delay)));
		return true;
	}
}

void soundplayer::stop_sound(std::string name)
{
	std::multimap<std::string, sound_delay>::iterator i;
	for(i = playing_sounds.find(name); i != playing_sounds.end() && i->first == name; i++) {
		i->second.s->Stop();
	}
}

void soundplayer::pause()
{
	std::multimap<std::string, sound_delay>::iterator i;
	for(i = playing_sounds.begin(); i != playing_sounds.end(); i++) {
		i->second.pause();
	}
}

void soundplayer::set_volume(double vol)
{
	volume = vol;
	std::multimap<std::string, sound_delay>::iterator i;
	for(i = playing_sounds.begin(); i != playing_sounds.end(); i++) {
		i->second.s->SetVolume(vol);
	}

}

void soundplayer::unpause()
{
	std::multimap<std::string, sound_delay>::iterator i;
	for(i = playing_sounds.begin(); i != playing_sounds.end(); i++) {
		i->second.unpause();
	}
}

void soundplayer::update()
{
	std::multimap<std::string, sound_delay>::iterator i;
	for(i = playing_sounds.begin(); i != playing_sounds.end();) {
		i->second.update();
		if(i->second.stopped()) {
			delete i->second.s;
			playing_sounds.erase(i++);
		} else {
			++i;
		}
	}
}
