/***************************************************************************
*   Copyright (C) 2010 by
*    Santtu Keskinen <laquendi@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include "world.h"
#include "spell.h"


spell_info_container::spell_info_container() {
	//cc_grow_mushroom
	infos.push_back(spell_info("Grow muhsroom", "grow_mushroom")
		.set_desc("Grow new mushroom. Every mushroom costs more energy than last one.")
		.set_target(spell_info::ground).set_range(100).set_hotkey('e')
		.set_e_cost(50).set_s_cd(30)
	);
	//cc_connect
	infos.push_back(spell_info("Connect mushroom", "connect_mushroom")
		.set_desc("Connect command center to a mushroom")
		.set_target(spell_info::mushroom_growing).set_range(200).set_hotkey('c')
		.set_e_cost(30)
	);
	//cc_fertilize_str	
	infos.push_back(spell_info("Fertilizer strength", "fertilize_str")
		.set_desc("Boost attack mushrooms, harms tanks. Energy cost per selected mushroom")
		.set_hotkey('s').set_e_cost(20)
	);
	//cc_fertilize_mana
	infos.push_back(spell_info("Fertilizer mana", "fertilize_mana")
		.set_desc("Boost spore mushrooms, harms attacks. Energy cost per selected mushroom")
		.set_hotkey('a').set_e_cost(20)
	);
	//cc_fertilize_dur
	infos.push_back(spell_info("Fertilizer durability", "fertilize_dur")
		.set_desc("Boost tanks mushrooms, harms spores. Energy cost per selected mushroom")
		.set_hotkey('d').set_e_cost(20)
	);
	//mushroom_upg_to_attack
	infos.push_back(spell_info("Attack upgrade", "upg_to_attack")
		.set_desc("Turns mushroom into attack mushroom")
		.set_hotkey('a').set_e_cost(20)
	);
	//mushroom_upg_to_spore
	infos.push_back(spell_info("Spore upgrade", "upg_to_spore")
		.set_desc("Turns mushroom into spore mushroom")
		.set_hotkey('s')
	);
	//mushroom_upg_to_tank
	infos.push_back(spell_info("Tank upgrade", "upg_to_tank")
		.set_desc("Turns mushroom into tank mushroom")
		.set_hotkey('t')
	);
	//mushroom_connect
	infos.push_back(spell_info("Connect", "connect_mushroom")
		.set_desc("Connect two mushrooms")
		.set_target(spell_info::mushroom_growing).set_hotkey('c').set_e_cost(20)
		.set_range(1.5)
	);
	//mushroom_multiply
	infos.push_back(spell_info("Multiply", "grow_mushroom")
		.set_desc("Grow new mushroom")
		.set_target(spell_info::ground).set_hotkey('e').set_range(1.2).set_e_cost(40)
		.set_g_cd(7).set_s_cd(15)
	);
	//mushroom_give_energy
	infos.push_back(spell_info("Give energy", "mana_orb")
		.set_desc("Give energy to linked mushroom with 0.35 efficiency.")
		.set_e_cost(20).set_range(1337).set_g_cd(0)
		.set_hotkey('g').set_target(spell_info::mushroom_growing)
	);
	//mushroom_attack_wall
	infos.push_back(spell_info("Destroy wall", "attack_wall")
		.set_desc("Deal damage to wall").set_s_cd(10)
		.set_target(spell_info::wall).set_hotkey('w').set_range(1.6).set_e_cost(20)
	);
	//mushroom_target_ant
	infos.push_back(spell_info("Set target", "target")
		.set_desc("Make mushroom attack selected ant")
		.set_target(spell_info::ant).set_hotkey('a').set_range(4).set_g_cd(0)
	);
	//mushroom_paralyse
	infos.push_back(spell_info("Paralyse", "paralyse")
		.set_desc("Paralyses target ant making it unable to move")
		.set_hotkey('r').set_target(spell_info::ant).set_range(1).set_e_cost(10)
	);
	//mushroom_heal
	infos.push_back(spell_info("Heal", "heal")
		.set_desc("Heal connected mushroom")
		.set_range(1337).set_e_cost(15).set_g_cd(0)
		.set_target(spell_info::mushroom_growing).set_hotkey('e')
	);
	//mushroom_taunt
	infos.push_back(spell_info("Taunt", "taunt")
		.set_desc("Get nearby ants to target this mushroom")
		.set_hotkey('t').set_s_cd(40).set_e_cost(5)
	);
	//unicorn_invisibility
	infos.push_back(spell_info("Invisibility", "invisibility")
		.set_desc("Make mushrooms and command center invisible for some time")
		.set_range(150).set_s_cd(60)
		.set_target(spell_info::ground).set_hotkey('v')
	);
	//unicorn_dimension_door
	infos.push_back(spell_info("Dimension door", "dimension_door")
		.set_desc("Teleport to a new location")
		.set_check_los(false).set_range(300).set_req_level(2)
		.set_target(spell_info::ground).set_hotkey('d')
	);
	//unicorn_mana_orb
	infos.push_back(spell_info("Mana orb", "mana_orb")
		.set_desc("Give energy to mushrooms in area")
		.set_s_cd(40)
		.set_target(spell_info::ground).set_hotkey('a').set_req_level(2)
	);
	//unicorn_diagonal_spawn
	infos.push_back(spell_info("Diagonal spawn","diagonal_spawn")
		.set_desc("Spawns up to two mushrooms from a spore mushroom along all diagonals")
		.set_req_level(3).set_s_cd(90)
		.set_target(spell_info::mushroom).set_hotkey('s')
	);
	//unicorn_spawn_mushroom
	infos.push_back(spell_info("Spawn mushroom", "grow_mushroom")
		.set_desc("Make a shroom, can't be casted too up")
		.set_req_level(4).set_y_limit(300).set_s_cd(15)
		.set_target(spell_info::ground).set_hotkey('e')
	);
	//unicorn_resurrect
	infos.push_back(spell_info("Resurrect", "resurrect")
		.set_desc("Resurrect 10 dead mushrooms")
		.set_hotkey('r').set_req_level(4).set_s_cd(180)
	);		
	//minotaur_attack_stance
	infos.push_back(spell_info("Attack stance", "attack_stance")
		.set_desc("Upgrade target mushroom of any type into attack mushroom")
		.set_target(spell_info::mushroom).set_hotkey('a').set_s_cd(20)
	);
	//minotaur_throw_mushroom
	infos.push_back(spell_info("Throw mushroom", "throw_mushroom")
		.set_desc("Throw nearest mushroom to target location")
		.set_target(spell_info::ground).set_hotkey('t').set_range(250)
		.set_req_level(2).set_s_cd(20)
	);
	//minotaur_build_cc
	infos.push_back(spell_info("Build command center", "build_cc")
		.set_desc("Build new command center")
		.set_target(spell_info::ground).set_hotkey('c').set_y_limit(300)
		.set_req_level(3).set_s_cd(180).set_g_cd(30)
	);
	//minotaur_mass_connect
	infos.push_back(spell_info("Mass connect", "mass_connect")
		.set_desc("Connect all mushrooms and command centers in area")
		.set_hotkey('s').set_req_level(3).set_s_cd(20)
	);
	//minotaur_attack_wall
	infos.push_back(spell_info("Chop wall", "minotaur_attack_wall")
		.set_desc("Deal damage to wall")
		.set_target(spell_info::wall).set_hotkey('w').set_range(70)
		.set_req_level(4).set_s_cd(10)
	);
	//minotaur_ants_bane
	infos.push_back(spell_info("Ants' bane", "ants_bane")
		.set_desc("Secret technique that kills all ants")
		.set_hotkey('b').set_req_level(4).set_s_cd(45)
	);
	//griffin_paralyse_trap
	infos.push_back(spell_info("Paralyse trap", "paralyse_trap_icon")
		.set_desc("Set up a paralyse trap")
		.set_target(spell_info::ground).set_hotkey('a').set_s_cd(6)
	);
	//griffin_kill_ant
	infos.push_back(spell_info("Kill ant", "kill_ant")
		.set_desc("Kills target ant")
		.set_target(spell_info::ant).set_range(40).set_hotkey('d')
		.set_req_level(2).set_s_cd(20)
	);
	//griffin_eat_mushroom
	infos.push_back(spell_info("Eat mushroom", "eat_mushroom")
		.set_desc("Eat mushroom for 250exp")
		.set_target(spell_info::mushroom).set_hotkey('e')
		.set_req_level(2).set_s_cd(15)
	);
	//griffin_explosive_trap
	infos.push_back(spell_info("Explosive trap", "explosive_trap_icon")
		.set_desc("Set up a explosive trap")
		.set_target(spell_info::ground).set_hotkey('x')
		.set_req_level(3).set_s_cd(15)
	);
	//griffin_boost_stats
	infos.push_back(spell_info("Boost stats", "boost_stats")
		.set_desc("Boost your mushrooms' stats").set_hotkey('b')
		.set_req_level(3).set_s_cd(60).set_g_cd(15)
	);
	//griffin_immortality
	infos.push_back(spell_info("Immortality", "immortality")
		.set_desc("Make your forces immune to damage").set_hotkey('r').set_s_cd(60)
		.set_req_level(4)
	);
}

void diagonal_spawn(sf::Vector2f dir, mushroom *spawner, world &w) {
	std::vector<mushroom*> &mushrooms = w.get_mushrooms();
	
	int max_tries = 4;
	int tries = 1;
	int success = 0;
	
	while (tries <= max_tries && success < 2) {
		sf::Vector2f pos = spawner->get_pos() + sf::Vector2f(dir.x*(40 * tries),
						dir.y*(40*tries));
		if(!w.out_of_bounds(pos) && w.get_map().los(spawner->get_center(), pos))
		{
			mushroom *m = new mushroom(w.anim_loader);
			m->set_pos(pos);
			
			if(!w.collision(*m)) {
				spawner->connect(m);
				m->connect(spawner);
				
				mushrooms.push_back(m);
				w.add_obj(m);
				success++;
			} else {
				delete m;
			}
		}
		tries++;
	}
}

bool spell::cast(selectable *caster, sf::Vector2f pos, world &w) const
{
	if(!can_cast(caster, pos, w)) 
		return false;
	
	sf::Vector2f caster_center = caster->get_center();
	mushroom *c_mushroom = dynamic_cast<mushroom*>(caster);
	creature *c_creature = dynamic_cast<creature*>(caster);
	command_center *c_cc = dynamic_cast<command_center*>(caster);
	
	mushroom *nearest_mushroom = w.nearest_mushroom(pos, SELECT_MUSHROOM_RANGE);
	mushroom *nearest_mushroom_growing = w.nearest_mushroom(pos, SELECT_MUSHROOM_RANGE, true);
//	command_center *nearest_cc = w.nearest_cc(pos, SELECT_CC_RANGE);
	ant *nearest_ant = w.nearest_ant(pos, SELECT_ANT_RANGE);

	// spell effects
	switch(t) {
		case cc_grow_mushroom: 
		{
			std::vector<mushroom*> &mushrooms = w.get_mushrooms();
			mushroom *m = new mushroom(w.anim_loader);
			m->set_pos(pos - sf::Vector2f(m->get_w()/2, m->get_h()/2));

			if(w.collision(*m)) {
				delete m;
				return false;
			}
			
			c_cc->connect_mushroom(m);
		
			mushrooms.push_back(m);
			w.add_obj(m);
		}
		break;
		case cc_connect:
		{
			if(!c_cc->is_connected(nearest_mushroom_growing)) {
				c_cc->connect_mushroom(nearest_mushroom_growing);
				w.check_win();

				goto success;
			}
			return false;
		}
		break;
		case cc_fertilize_str:
		{
			const std::list<mushroom*> &tree = c_cc->get_tree();
			if(tree.size()==0)
				return false;
			std::list<mushroom*>::const_iterator it;
			for(it = tree.begin(); it != tree.end(); it++) {
				if((*it)->get_type() == mushroom::m_attack)
					(*it)->change_modifier(12);
				if((*it)->get_type() == mushroom::m_tank)
					(*it)->change_modifier(-7);
			}
		}
		break;
		case cc_fertilize_mana:
		{
			const std::list<mushroom*> &tree = c_cc->get_tree();
			if(tree.size()==0)
				return false;
			std::list<mushroom*>::const_iterator it;
			for(it = tree.begin(); it != tree.end(); it++) {
				if((*it)->get_type() == mushroom::m_spore)
					(*it)->change_modifier(12);
				if((*it)->get_type() == mushroom::m_attack)
					(*it)->change_modifier(-7);
			}
		}
		break;
		case cc_fertilize_dur:
		{
			const std::list<mushroom*> &tree = c_cc->get_tree();
			if(tree.size()==0)
				return false;
			std::list<mushroom*>::const_iterator it;
			for(it = tree.begin(); it != tree.end(); it++) {
				if((*it)->get_type() == mushroom::m_tank)
					(*it)->change_modifier(12);
				if((*it)->get_type() == mushroom::m_spore)
					(*it)->change_modifier(-7);
			}
		}
		break;
		case mushroom_upg_to_attack: 
		{
			c_mushroom->grow(mushroom::m_attack);
		}
		break;
		case mushroom_upg_to_spore: 
		{
			c_mushroom->grow(mushroom::m_spore);
		}
		break;
		case mushroom_upg_to_tank: 
		{
			c_mushroom->grow(mushroom::m_tank);
		}
		break;
		case mushroom_connect:
		{
			if(!c_mushroom->is_connected(nearest_mushroom_growing)) {
				nearest_mushroom_growing->connect(c_mushroom);
				c_mushroom->connect(nearest_mushroom_growing);

				w.check_win();
				goto success;
			}
			return false;
		}
		break;
		case mushroom_multiply:
		{
			std::vector<mushroom*> &mushrooms = w.get_mushrooms();
			mushroom *m = new mushroom(w.anim_loader);
			m->set_pos(pos - sf::Vector2f(m->get_w()/2, m->get_h()/2));

			if(w.collision(*m)) {
				delete m;
				return false;
			}

			c_mushroom->connect(m);
			m->connect(c_mushroom);
			mushrooms.push_back(m);
			w.add_obj(m);
		}
		break;
		case mushroom_give_energy:
		{
			std::list<mushroom*> l = c_mushroom->get_connections();
			std::list<mushroom*>::iterator it;
			for(it = l.begin(); it != l.end(); it++) {
				if((*it) == nearest_mushroom_growing) {
					nearest_mushroom_growing->add_energy(get_energy_cost(caster)*0.35);
					goto success;
				}
			}
			return false;
		}
		break;
		case mushroom_attack_wall:
		{
			tile & t = w.get_map().get_tile(sf::Vector2i(pos.x / TILE_W, pos.y / TILE_H));
			t.hit(w.anim_loader, 30);
		}
		break;
		case mushroom_target_ant:
		{
			c_mushroom->set_target(nearest_ant);
		}
		break;
		case mushroom_paralyse:
		{
			nearest_ant->paralyse(7.0f);
		}
		break;
		case mushroom_heal:
		{
			std::list<mushroom*> l = c_mushroom->get_connections();
			std::list<mushroom*>::iterator it;
			for(it = l.begin(); it != l.end(); it++) {
				if((*it) == nearest_mushroom_growing) {
					nearest_mushroom_growing->add_hp(10);
					goto success;
				}
			}
			return false;
		}
		break;
		case mushroom_taunt:
		{
			std::vector<ant*> &ants = w.get_ants();
			for(size_t a = 0; a < ants.size(); a++) {
				if(dist(c_mushroom->get_center(), ants[a]->get_center()) <= 200.0f) {
					ants[a]->set_target(c_mushroom);
				}
			}
		}
		break;
		case unicorn_invisibility:
		{
			std::list<selectable*> objs = w.get_m_and_cc_in_range(pos, 150);
			std::list<selectable*>::iterator it;
			for(it = objs.begin(); it != objs.end(); it++) {
				(*it)->set_invisible(45.0f);
			}
		}
		break;
		case unicorn_dimension_door:
		{
			sf::Vector2f cur_pos = caster->get_pos();
			w.obj_map_remove(caster);
			caster->set_pos(sf::Vector2f(pos.x-caster->get_w()/2, pos.y-caster->get_h()/2));
			if(w.collision(*caster)) {
				caster->set_pos(cur_pos);
				w.obj_map_add(caster);
				return false;
			}
			w.obj_map_add(caster);
			
			c_creature->set_move_pos(c_creature->get_center());
		}
		break;
		case unicorn_mana_orb:
		{	
			std::vector<mushroom*>::iterator it = w.get_mushrooms().begin();
			for(;it != w.get_mushrooms().end(); it++) {
				if(dist(pos, (*it)->get_center()) < 100)
					(*it)->add_energy(15.0f);
			}
		}
		break;
		case unicorn_diagonal_spawn:
		{
			if(nearest_mushroom->get_type() == mushroom::m_spore) {
				diagonal_spawn(sf::Vector2f(-1, -1), nearest_mushroom, w);
				diagonal_spawn(sf::Vector2f(-1, 1), nearest_mushroom, w);
				diagonal_spawn(sf::Vector2f(1, -1), nearest_mushroom, w);
				diagonal_spawn(sf::Vector2f(1, 1), nearest_mushroom, w);
			} else {
				return false;
			}
		}
		break;
		case unicorn_spawn_mushroom: 
		{
			std::vector<mushroom*> &mushrooms = w.get_mushrooms();
			mushroom *m = new mushroom(w.anim_loader);
			m->set_pos(pos - sf::Vector2f(m->get_w()/2, m->get_h()/2));
			
			if(w.collision(*m)) {
				delete m;
				return false;
			}
		
			mushrooms.push_back(m);
			w.add_obj(m);
		}
		break;
		case unicorn_resurrect:
		{
			int i = 0;
			while (i < 10 && w.has_deceased_m()) {
				std::pair<sf::Vector2f, mushroom::mushroom_type> dead = 
						w.get_deceased_m();
				mushroom *m = new mushroom(w.anim_loader);
				m->set_pos(dead.first);
				if(w.collision(*m)) {
					delete m;
				} else {
					i++;
					m->stop_upgrade();
					m->upgrade(dead.second);
					m->set_mode("stand");
					m->calculate_abilities();
					m->add_hp(m->get_max_hp());
					w.get_mushrooms().push_back(m);
					w.add_obj(m);
				}
			}
		}
		break;
		case minotaur_attack_stance:
		{
			nearest_mushroom->grow(mushroom::m_attack);
			nearest_mushroom->set_grow_time(10.0f);
		}
		break;	
		case minotaur_throw_mushroom:
		{
			mushroom *throwed = w.nearest_mushroom(caster->get_center(), 80.0f);
			if(!throwed)
				return false;
			w.obj_map_remove(throwed);
			sf::Vector2f prev_pos = throwed->get_pos();
			throwed->set_pos(pos - sf::Vector2f(throwed->get_w()/2, throwed->get_h()/2));

			if(w.collision(*throwed)) {
				throwed->set_pos(prev_pos);
				w.obj_map_add(throwed);
				return false;
			}
			w.obj_map_add(throwed);
			w.disconnect_mushroom(throwed);
			throwed->get_connections().clear();
		}
		break;	
		case minotaur_build_cc:
		{
			std::vector<command_center*> &ccs = w.get_command_centers();
			command_center *cc = new command_center(w.anim_loader);
			cc->set_pos(pos - sf::Vector2f(cc->get_w()/2, cc->get_h()/2));

			if(w.collision(*cc)) {
				delete cc;
				return false;
			}
			
			ccs.push_back(cc);
			w.add_obj(cc);
		}
		break;
		case minotaur_mass_connect:
		{
			std::list<selectable*> objs = w.get_m_and_cc_in_range(caster->get_center(), 200.0f);
			std::list<selectable*>::iterator it1, it2;
			for(it1 = objs.begin(); it1 != objs.end(); it1++) {
				mushroom *m1 = dynamic_cast<mushroom*>(*it1);
				command_center *cc1 = dynamic_cast<command_center*>(*it1);
				if(m1) {
					for(it2 = objs.begin(); it2 != objs.end(); it2++) {
						if(it1 == it2)
							continue;
						mushroom *m2 = dynamic_cast<mushroom*>(*it2);
						if(m2) {
							if(w.get_map().los(m1->get_center(), m2->get_center()))
								m1->connect(m2);
						}
					}
				} else if(cc1) {
					for(it2 = objs.begin(); it2 != objs.end(); it2++) {
						if(it1 == it2)
							continue;
						mushroom *m2 = dynamic_cast<mushroom*>(*it2);
						if(m2)
							if(w.get_map().los(cc1->get_center(), m2->get_center()))
								cc1->connect_mushroom(m2);
					}
				}
			}
		}
		break;
		case minotaur_attack_wall:
		{
			tile & t = w.get_map().get_tile(sf::Vector2i(pos.x / TILE_W, pos.y / TILE_H));
			t.hit(w.anim_loader, 70);
		}
		case minotaur_ants_bane:
		{
			std::vector<ant*> &ants = w.get_ants();
			for(size_t a = 0; a < ants.size(); a++) 
				ants[a]->add_hp(-ants[a]->get_max_hp()-1);
		}
		break;	
		break;
		case griffin_paralyse_trap:
		{
			std::vector<trap*> &traps = w.get_traps();
			trap *t = new trap(trap::paralyse, w.anim_loader);
			t->set_pos(pos - sf::Vector2f(t->get_w()/2, t->get_h()/2));
			
			if(w.collision(*t)) {
				delete t;
				return false;
			}
		
			traps.push_back(t);
			w.add_obj(t);
		}
		break;
		case griffin_kill_ant:
		{
			nearest_ant->add_hp(-nearest_ant->get_max_hp()-1);
		}
		break;
		case griffin_eat_mushroom:
		{
			w.disconnect_mushroom(nearest_mushroom);

			std::vector<mushroom*> &mushrooms = w.get_mushrooms();
			std::vector<mushroom*>::iterator it = mushrooms.begin();
			for(;it!=mushrooms.end(); it++)
			{
				if(nearest_mushroom==(*it))
				{
					w.delete_obj(*it);
					mushrooms.erase(it);
					break;
				}
			}
			w.get_player().gain_exp(w, 250);
		}
		break;
		case griffin_explosive_trap:
		{
			std::vector<trap*> &traps = w.get_traps();
			trap *t = new trap(trap::explosive, w.anim_loader);
			t->set_pos(pos - sf::Vector2f(t->get_w()/2, t->get_h()/2));
			
			if(w.collision(*t)) {
				delete t;
				return false;
			}
		
			traps.push_back(t);
			w.add_obj(t);
		}
		break;
		case griffin_boost_stats:
		{
			w.get_player().boost_stats(5);
		}
		break;
		case griffin_immortality:
		{
			std::vector<mushroom*> mushrooms = w.get_mushrooms();
			std::vector<command_center*> ccs = w.get_command_centers();

			for(size_t a = 0; a < mushrooms.size(); a++) {
				mushrooms[a]->set_immortal(25.0f);
			}
			for(size_t a = 0; a < ccs.size(); a++) {
				ccs[a]->set_immortal(25.0f);
			}
		}
		break;
		default:
			return false;
	}

success:
	
	w.handler.cast_spell(caster, *this);

	return true;
}

