/***************************************************************************
*   Copyright (C) 2010 by
*    Santtu Keskinen <laquendi@gmail.com>
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include <algorithm>
#include <cstring>
#include <sstream>
#include "spellhotkey.h"
#include "world.h"
#include "settings.h"

spell_hotkey_handler::spell_hotkey_handler()
{
	config &conf = config::get();
	mode = (spell_hotkey_mode)conf.get_value<int>("spell_hotkey_mode");
	for(size_t a = 0; a < HOTKEYS; a++) {
		std::stringstream k;
		k << "key" << a;
		layout[a] = conf.get_value<int>(k.str());
	}
}

bool spell_hotkey_handler::pressed(sf::Key::Code code, world& w, spell &cur_spell)
{
	std::vector<spell> &spells = w.get_selected()->get_spells();
	if(mode == hotkey) {
		for(size_t a = 0; a < spells.size(); a++) {
			if(spells[a].available(w.get_selected(), w) && spells[a].get_hotkey() == code) {
				cur_spell = spells[a];
				return true;
			}
		}
	} else if (mode == positional) {
		for(size_t a=0; a < HOTKEYS; a++) {
			if(a < spells.size())
				if(code == layout[a] && spells[a].available(w.get_selected(), w)) {
					cur_spell = spells[a];
					return true;
			}
		}
	}
	return false;
}
