/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*    Santtu Keskinen <laquendi@gamail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include <sstream>
#include "config.h"
#include "volumewidget.h"

volume_widget::volume_widget(Gui::Rect r, std::string _type,
		musicplayer &_mp, soundplayer &_sp,
		sf::Image &up_img, sf::Image &down_img) :
	Gui::VerticalList(r, 1), type(_type), mp(_mp), sp(_sp)
{
	std::string p = "gfx/";
	std::string nms = "_no_mute.png";
	std::string ms = "_mute.png";
	notmuted.LoadFromFile(p + type + nms);
	muted.LoadFromFile(p + type + ms);

	up = new Gui::ImgButton(up_img);
	toggle = new Gui::ImgButton(Gui::Rect(0, 0, 40, 40));
	down = new Gui::ImgButton(down_img);

	label = new Gui::TextLabel();
	label->SetSize(14);
	label->SetFontColor(sf::Color::Blue);

	this->Add(up)->
		Add(toggle)->
		Add(down)->
		Add(new Gui::Object(Gui::Rect(0, 0, 10, 9)))->
		Add(label);
	label->SetRelX(9);

	read_config();
	update();
	SetActionListener(this);
}

void volume_widget::read_config()
{
	config &conf = config::get();
	volume = conf.get_value<double>(type + "_volume");
	mute = conf.get_value<int>(type + "_muted");
}

void volume_widget::update()
{
	if(mute)
		toggle->SetImage(muted);
	else
		toggle->SetImage(notmuted);

	std::stringstream str;
	str << volume;
	label->SetLabel(str.str());

	if(type == "music") {
		if(mute) {
			mp.set_volume(0);
		} else {
			mp.set_volume(volume);
		}
	} else if(type == "sound") {
		if(mute) {
			sp.set_volume(0);
		} else {
			sp.set_volume(volume);
		}
	}
}

void volume_widget::write_config()
{
	config &conf = config::get();
	conf.set_value<double>(type + "_volume", volume);
	conf.set_value<int>(type + "_muted", mute);
}

void volume_widget::ButtonClick(Gui::ID srcid)
{
	if(srcid == up->GetID()) {
		volume += 10;
	} else if(srcid == down->GetID()) {
		volume -= 10;
	} else if(srcid == toggle->GetID()) {
		mute = !mute;
		update();
	}

	if(volume > 100.0f) {
		volume = 100.0f;
	} else if(volume < 0.0f) {
		volume = 0.0f;
	}

	write_config();
	update();
	/*Gui::ActionListener *l = parent->GetListener();
	
	if(l) {
		l->ButtonClick(id);
	}*/
	
}
