/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _VOLUME_WIDGET
#define _VOLUME_WIDGET

#include <SFML/Graphics.hpp>
#include "gui.h"
#include "musicplayer.h"
#include "soundplayer.h"

class volume_widget : public Gui::VerticalList, public Gui::ActionListener {
	public:
		volume_widget(Gui::Rect rect, std::string type,
				musicplayer &mp, soundplayer &sp,
				sf::Image &up_img, sf::Image &down_img);

		virtual void ButtonClick(Gui::ID);
	private:
		void read_config();
		void update();
		void write_config();

		double volume;
		bool mute;

		Gui::ImgButton *toggle;
		Gui::ImgButton *up, *down;
		Gui::TextLabel *label;

		std::string type;

		sf::Image notmuted, muted;
		musicplayer &mp;
		soundplayer &sp;
};

#endif
