/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _WIND_H
#define _WIND_H

class world;

#ifndef NO_GRAPHICS
#include <SFML/Graphics.hpp>
#include "particle.h"

class wind_emitter : public particle_emitter {
	public: 
		wind_emitter(double rate) : 
			particle_emitter(rate) { }
	protected:
		virtual particle create();
};
#endif

class wind {
	public:
		wind(double start_time, double length, double interval);

		void update(world &);
#ifndef NO_GRAPHICS
		void draw(sf::RenderTarget &);
#endif
		double get_time_left() { return time_left; }
		static const double speed;
	private:
		bool blowing;
		double time_left;
		double length;
		double interval;
		double afterflow;
		bool afterflow_stop;

		int blow_count;

#ifndef NO_GRAPHICS
		particle_engine engine;
#endif
};

#endif
