#!BPY

"""
Name: 'NajuEngine mesh (.xml)'
Blender: 249
Group: 'Export'
Tooltip: 'Export to NajuEngine mesh file format (.xml).'
"""

__author__ = "Tatu Kilappa, Sami Vuolli"
__url__ = ["http://faemiyah.fi"]
__version__ = "0.0.1"
__email__ = ["tatu.kilappa:iki*fi", "scripts"]
__bpydoc__ = """\
This scripts exports mesh files for NajuEngine (.xml)
"""

# You should have received this file along a version of Naju engine, copy it to
# the Blender scripts folder.
#
# This file pertains to the Naju engine licencing.

import Blender, meshtools
from Blender import Material
import os
import re
import sys

INDENT = 1

class XmlFile:
	def __init__(self, pfilename, ptype):
		self.filename = pfilename
		self.file = open(pfilename, "wb")
		self.indent = 0
		self.type = ptype
		self.printLine('<?xml version="1.0" encoding="utf-8"?>')
		self.printLine("<" + ptype + ' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema">')

	def close(self):
		self.printLine("</%s>" % (self.type), -INDENT)
		self.file.close()
		meshtools.print_boxed("saved " + self.filename)

	def printLine(self, str, indent_change_before = 0):
		self.indent += indent_change_before
		if self.indent < 0:
			self.indent = 0
		ii = self.indent
		while ii > 0:
			print >>self.file, "\t",
			ii -= 1
		print >>self.file, str

def save_naju_mesh(filename):
	filename = re.sub(r'\.[^\.]*$', '', filename)

	objs = Blender.Object.GetSelected()

	for ii in xrange(len(objs)):
		obj = objs[ii]
		if ii == 0:
			meshtools.print_boxed("root mesh " + obj.name)
			save_naju_mesh_obj(filename, obj)
		else:
			meshtools.print_boxed("submesh " + obj.name)
			save_naju_mesh_obj(filename, obj, ii - 1)

def save_naju_mesh_obj(filename, obj, subidx = None):
	mesh = obj.data

	if None != subidx:
		filename += '-%i' % (subidx)

	images = []
	for face in mesh.faces:
		if face.image and (not face.image in images):
			images += [face.image]

	if len(images) > 1:
		metafile = XmlFile(filename + ".mmesh", "meta-mesh")
		metafile.printLine("<scale>", INDENT)
		metafile.printLine("<center>0</center>", INDENT)
		metafile.printLine("<into>0</into>")
		metafile.printLine("<x>1.0</x>")
		metafile.printLine("<y>1.0</y>")
		metafile.printLine("<z>1.0</z>")
		metafile.printLine("</scale>", -INDENT)
		for ii in xrange(len(images)):
			fname = '%s_%i.mesh' % (filename, ii)
			save_naju_mesh_sub(obj, images[ii], fname, subidx)
			metafile.printLine("<mesh>%s</mesh>" % (os.path.basename(fname)))
		metafile.close()
	elif len(images) == 1:
		save_naju_mesh_sub(obj, images[0], filename + '.mesh', subidx)
	else:
		save_naju_mesh_sub(obj, None, filename + '.mesh', subidx)

def save_naju_mesh_sub(obj, image, filename, subidx):
	mesh = obj.data
	numverts = 0
	vdict = {}

	file = XmlFile(filename, "mesh")
	file.printLine("<scale>", INDENT)
	file.printLine("<center>0</center>", INDENT)
	file.printLine("<into>0</into>")
	file.printLine("<x>1.0</x>")
	file.printLine("<y>1.0</y>")
	file.printLine("<z>1.0</z>")
	file.printLine("</scale>", -INDENT)

	if None != subidx:
		file.printLine('<offset>')
		file.printLine('<x>%f</x>' % (obj.LocX), INDENT)
		file.printLine('<y>%f</y>' % (obj.LocY))
		file.printLine('<z>%f</z>' % (obj.LocZ))
		file.printLine('</offset>', -INDENT)

	for face in mesh.faces:
		if face.image != image:
			continue
		ver = face.v
		for ii in xrange(len(ver)):
			vv = ver[ii]
			key = vv.index, face.materialIndex
			if not vdict.has_key(key):
				vdict[key] = numverts
				numverts += 1
				mat = mesh.materials[face.materialIndex]
				co = vv.co
				file.printLine("<vertex>")
				file.printLine("<color>", INDENT)
				file.printLine("<r>%f</r>" % (mat.R), INDENT)
				file.printLine("<g>%f</g>" % (mat.G))
				file.printLine("<b>%f</b>" % (mat.B))
				file.printLine("<a>%f</a>" % (1.0))
				file.printLine("</color>", -INDENT)
				if image:
					uv = face.uv[ii]
					file.printLine("<texcoord>")
					file.printLine("<s>%f</s>" % (uv[0]), INDENT)
					file.printLine("<t>%f</t>" % (uv[1]))
					file.printLine("</texcoord>", -INDENT)
				file.printLine("<x>%f</x>" % (co[0]))
				file.printLine("<y>%f</y>" % (co[1]))
				file.printLine("<z>%f</z>" % (co[2]))
				file.printLine("</vertex>", -INDENT)

	for face in mesh.faces:
		if face.image != image:
			continue
		file.printLine("<face>")
		i1 = vdict[face[0].index, face.materialIndex]
		i2 = vdict[face[1].index, face.materialIndex]
		i3 = vdict[face[2].index, face.materialIndex]
		file.printLine("<a>%i</a>" % (i1), INDENT)
		file.printLine("<b>%i</b>" % (i2))
		file.printLine("<c>%i</c>" % (i3))
		if len(face.v) == 4:
			i4 = vdict[face[3].index, face.materialIndex]
			file.printLine("</face>", -INDENT)
			file.printLine("<face>")
			file.printLine("<a>%i</a>" % (i1), INDENT)
			file.printLine("<b>%i</b>" % (i3))
			file.printLine("<c>%i</c>" % (i4))
		file.printLine("</face>", -INDENT)
 
	tpath = "gfx/textures"
	if image:
		tex = os.path.basename(image.filename)
	else:
		tex = "stub.png"
	file.printLine("<texture>%s/%s</texture>" % (tpath, tex))
	file.close()

Blender.Window.FileSelector(save_naju_mesh, "Export to mesh (.xml)")

