#!/usr/bin/python
# -*- coding: utf-8 -*-

def CheckBoostVersion(context, version):
  """
  Expects version in format 'major.minor.patch'.
  Patch is optional.
  """
  context.Message("Checking for Boost version >= %s... " % (version))

  v = version.split('.', 2)
  
  ver = 100000 * int(v[0]) + 100 * int(v[1])
  if(len(v) > 2):
    ver += int(v[2])

  conf_test = """
  #include <boost/version.hpp>
  #if !( BOOST_VERSION >= %d )
  #error Too old Boost
  #endif
  int main() {}
  """ % (ver)

  r = context.TryLink(conf_test, '.cpp')

  context.Result(r)
  return r

def CheckBoostLib(context, libname, symbol=None):
  context.Message('Checking for Boost lib: %s... ' % (libname))
  libs = context.env.get('LIBS')

  sym = ""
  if symbol:
    sym = symbol + ';'

  conf_test = """
  int main() { %s }
  """ % (sym)
  
  for suffix in ['', '-mt']:
    context.env.Append(LIBS = ['boost_'+libname+suffix])
    if context.TryLink(conf_test, '.cpp'):
      context.Result(True)
      return True
    context.env.Replace(LIBS = libs)

  context.Result(False)
  return False

