#!/usr/bin/python
# -*- coding: utf-8 -*-

def CheckPkgConfig(context, version = '0.0'):
  """
  Check if pkg-config exists.
  Optional version must be in string.
  """
  context.Message('Checking for pkg-config... ')
  action = 'pkg-config --atleast-pkgconfig-version=%s' % (version)
  res = context.TryAction(action)[0]
  context.Result(res)
  return res

def CheckPkg(context, name, version = '0.0'):
  """
  Checks if package exists.
  Version is optional and must be a string
  """
  context.Message('Checking for pkg %s... ' % (name))
  action = 'pkg-config --atleast-version=%s %s' % (version, name)
  res = context.TryAction(action)[0]
  if res:
    context.env.ParseConfig('pkg-config --cflags --libs %s' % (name))
  context.Result(res)
  return res


