#!/usr/bin/python
# -*- coding: utf-8 -*-

def Try(context, version, header="SDL.h"):
  conf_test = """
  #include <iostream>
  #include <%s>
  #undef main
  int main(int argc, char *argv[])
  {
  """ % header
  if version:
    conf_test += """
    const Uint8 major = %i;
    const Uint8 minor = %i;
    const Uint8 patch = %i;
    Uint32 compare_ver = major<<16 + minor<<8 + patch;
    SDL_version ver;
    SDL_VERSION(&ver);
    std::cout<<"Header ver: "<<int(ver.major)
    <<"."<<int(ver.minor)<<"."<<int(ver.patch)<<"\\n";
    Uint32 header_ver = ver.major<<16 + ver.minor<<8 + ver.patch;
    ver = *SDL_Linked_Version();
    std::cout<<"Linked ver: "<<int(ver.major)
    <<"."<<int(ver.minor)<<"."<<int(ver.patch)<<"\\n";
    Uint32 linked_ver = ver.major<<16 + ver.minor<<8 + ver.patch;
    if( header_ver < compare_ver ||
        linked_ver < compare_ver )
        return 1;
    """ % version
  conf_test += """
    return 0;
  }
  """

  return context.TryRun(conf_test, '.cpp')[0]



def CheckSDL(context, version=None):
  """
  Check if SDL is present and if the version is defined that it's
  version number is greater of equal to that.
  Version must be a Python sequence (major, minor, patch).
  """
  import os
  msg='Checking for SDL'
  if version: msg+=' >= %i.%i.%i' % version
  msg+='... '
  context.Message(msg)

  if os.name == 'posix' and os.uname()[0] == 'Darwin':
    frameworks = context.env.get('FRAMEWORKS')
    context.env.Append(FRAMEWORKS = ['SDL', 'Cocoa'])
    if Try(context, version, 'SDL/SDL.h'):
      context.Result(True)
      return True
    context.env.Replace(FRAMEWORKS = frameworks)
  if context.TryAction('sdl-config --version')[0]:
    context.env.ParseConfig('sdl-config --libs --cflags')
    res = Try(context, version)
    context.Result(res)
    return res
  else:
    libs = context.env.get('LIBS')
    context.env.Append(LIBS = ['SDL', 'SDLmain'])
    res = Try(context, version)
    context.Result(res)
    return res

