#include "data/generic.hpp"

#include <fstream>
#include <sstream>

#include <boost/filesystem.hpp>

namespace fs = boost::filesystem;

using namespace data;

/** \brief Check that a file exists and is openable for reading.
 *
 * This is required because of boost::filesystem::exists does not seem to
 * work.
 *
 * @param pfname Filename
 */
bool file_exists(const char *pfname)
{
	FILE *ret = fopen(pfname, "r");
	if(!ret)
	{
		return false;
	}
	fclose(ret);
	return true;
}

/** \brief Wrapper for file exists check.
 *
 * @param pfname Filename.
 */
bool file_exists(const std::string &pfname)
{
	return file_exists(pfname.c_str());
}

shristr data::open_read(const std::string &pfname)
{
	// TODO: ZIPfile.
	
	// TODO: Datadir ZIPfile.
	
	return shristr(new std::ifstream(open_search(pfname).c_str(), std::ifstream::binary));
}

shrostr data::open_write(const std::string &pfname)
{
	shrostr ret(new std::ofstream(pfname.c_str()));
	if(ret->fail())
	{
		std::stringstream sstr;
		sstr << "could not open \"" << pfname << "\" for writing";
		BOOST_THROW_EXCEPTION(std::runtime_error(sstr.str()));
	}	
	return ret;
}

std::string data::open_search(const std::string &pfname)
{
	fs::path fpath(pfname);

	if(!file_exists(fpath.file_string()))
	{
#if defined(DATADIR)
		fpath = fs::path(DATADIR) / pfname;
		if(!file_exists(fpath.file_string()))
		{
#endif
			std::stringstream err;
			err << "could not find file: \"" << pfname << "\"";
			BOOST_THROW_EXCEPTION(std::runtime_error(err.str()));
#if defined(DATADIR)
		}
#endif
	}

	return fpath.file_string();
}

