#ifndef DATA_GENERIC_HPP
#define DATA_GENERIC_HPP

#include "defaults.hpp"

#include <vector>

namespace data
{
	/** Convenience typedef. */
	typedef boost::shared_ptr<std::istream> shristr;

	/** Convenience typedef. */
	typedef boost::shared_ptr<std::ostream> shrostr;

	/** \brief Open an input stream.
	 *
	 * The user must delete the returned ifstream object.
	 *
	 * @param pfname Filename to open.
	 * @return Newly reserved ifstream.
	 */
	shristr open_read(const std::string &pfname);

	/** \brief Open an output stream.
	 *
	 * The user must delete the returned ofstream object.
	 *
	 * @param pfname Filename to open.
	 * @return Newly reserved ifstream.
	 */
	shrostr open_write(const std::string &pfname);

	/** \brief Find a filename for input file.
	 *
	 * Throws an error if the file is not found.
	 *
	 * @param pfname Filename to open.
	 * @return Full path filename.
	 */
	std::string open_search(const std::string &pfname);

	/** \brief Trim excess memory usage from an STL vector.
	 *
	 * Also resizes the vector to eliminate the issue.
	 */
	template<typename T> void stl_trim(std::vector<T> &stlvec)
	{
		if(stlvec.capacity() != stlvec.size())
		{
			//std::cout << "Capacity change: " << stlvec.capacity() << " -> " << stlvec.size() << std::endl;
			stlvec.resize(stlvec.size());
		}
	}
}

#endif
