#include "gfx/array.hpp"

using namespace gfx;

ArrayBillboard::ArrayBillboard(unsigned size) :
	ArrayGeneric<BillboardElement>(size) { }

void ArrayBillboard::feed(unsigned am, unsigned at, unsigned ac, unsigned av)
{
	uint8_t *ptr = reinterpret_cast<uint8_t*>(m_array);
	glEnableVertexAttribArray(am);
	glVertexAttribPointer(am, 4, GL_BYTE, GL_TRUE, sizeof(BillboardElement), ptr);
	glEnableVertexAttribArray(at);
	glVertexAttribPointer(at, 2, GL_FLOAT, GL_FALSE, sizeof(BillboardElement), ptr + 4);
	glEnableVertexAttribArray(ac);
	glVertexAttribPointer(ac, 4, GL_UNSIGNED_BYTE, GL_TRUE, sizeof(BillboardElement), ptr + 12);
	glEnableVertexAttribArray(av);
	glVertexAttribPointer(av, 4, GL_FLOAT, GL_FALSE, sizeof(BillboardElement), ptr + 16);
}

