#include "gfx/buffer.hpp"

#include "gfx/lod.hpp"

namespace gfx
{
	template<> void BufferElem::update(Lod &lod)
	{
		std::vector<Lod*> lods;
		lod.collectAll(lods);

		unsigned idx = 0;
		std::vector<Triangle> triangles;
		BOOST_FOREACH(Lod *vv, lods)
		{
			vv->assignElem(idx);
			BOOST_FOREACH(const Triangle &tt, vv->getFaces())
			{
				triangles.push_back(tt);
				idx += 3 * static_cast<unsigned>(sizeof(GLuint));
			}
		}

		this->update(triangles);
	}
}

using namespace gfx;

void BufferInterleavedBBTCNV::feed(const Attribute &br, const Attribute &bw,
		const Attribute &tt, const Attribute &cc, const Attribute &nn,
		const Attribute &vv) const
{
	int32_t *offset = NULL;

	this->bind();

	br.enable();
	glVertexAttribPointer(br.id(), 4, GL_UNSIGNED_BYTE, GL_FALSE, BLOCKSIZE,
			offset);
	offset += 1;

	bw.enable();
	glVertexAttribPointer(bw.id(), 4, GL_FLOAT, GL_FALSE, BLOCKSIZE,
			offset);
	offset += 4;

	tt.enable();
	glVertexAttribPointer(tt.id(), 2, GL_FLOAT, GL_FALSE, BLOCKSIZE,
			offset);
	offset += 2;

	cc.enable();
	glVertexAttribPointer(cc.id(), 4, GL_UNSIGNED_BYTE, GL_TRUE, BLOCKSIZE,
			offset);
	offset += 1;

	nn.enable();
	glVertexAttribPointer(nn.id(), 3, GL_SHORT, GL_FALSE, BLOCKSIZE,
			offset);
	offset += 2;

	vv.enable();
	glVertexAttribPointer(vv.id(), 3, GL_FLOAT, GL_FALSE, BLOCKSIZE,
			offset);
}

void BufferInterleavedBBTCNV::update(const std::vector<math::vec4u> &br,
					const std::vector<math::vec4f> &bw,
					const std::vector<math::vec2f> &tt,
					const std::vector<Color> &cc,
					const std::vector<math::vec3f> &nn,
					const std::vector<math::vec3f> &vv)
{
	unsigned vcnt = static_cast<unsigned>(vv.size());
	int32_t *ildata = new int32_t[BLOCKSIZE / sizeof(int32_t) * vcnt],
					*iter = ildata;

	for(unsigned ii = 0; (ii < vcnt); ++ii)
	{
		uint8_t *rptr = reinterpret_cast<uint8_t*>(iter);
		rptr[0] = static_cast<uint8_t>(br[ii].x());
		rptr[1] = static_cast<uint8_t>(br[ii].y());
		rptr[2] = static_cast<uint8_t>(br[ii].z());
		rptr[3] = static_cast<uint8_t>(br[ii].w());
		iter += 1;

		float *wptr = reinterpret_cast<float*>(iter);
		wptr[0] = bw[ii].x();
		wptr[1] = bw[ii].y();
		wptr[2] = bw[ii].z();
		wptr[3] = bw[ii].w();
		iter += 4;

		float *tptr = reinterpret_cast<float*>(iter);
		tptr[0] = tt[ii].x();
		tptr[1] = tt[ii].y();
		iter += 2;

		uint8_t *cptr = reinterpret_cast<uint8_t*>(iter);
		cptr[0] = static_cast<uint8_t>(cc[ii].r() * 255.0f + 0.5f);
		cptr[1] = static_cast<uint8_t>(cc[ii].g() * 255.0f + 0.5f);
		cptr[2] = static_cast<uint8_t>(cc[ii].b() * 255.0f + 0.5f);
		cptr[3] = static_cast<uint8_t>(cc[ii].a() * 255.0f + 0.5f);
		iter += 1;

		int16_t *nptr = reinterpret_cast<int16_t*>(iter);
		nptr[0] = static_cast<int16_t>(nn[ii].x() * 16384.0f);
		nptr[1] = static_cast<int16_t>(nn[ii].y() * 16384.0f);
		nptr[2] = static_cast<int16_t>(nn[ii].z() * 16384.0f);
		iter += 2;

		float *vptr = reinterpret_cast<float*>(iter);
		vptr[0] = vv[ii].x();
		vptr[1] = vv[ii].y();
		vptr[2] = vv[ii].z();
		iter += 3;
	}

	this->reserve();
	this->bind();
	glBufferData(get_buffer_type(), BLOCKSIZE * vcnt, ildata, GL_STATIC_DRAW);
	delete[] ildata;
}

void BufferInterleavedTCNV::feed(const Attribute &tt, const Attribute &cc,
		const Attribute &nn, const Attribute &vv) const
{
	int32_t *offset = NULL;

	this->bind();

	tt.enable();
	glVertexAttribPointer(tt.id(), 2, GL_FLOAT, GL_FALSE, BLOCKSIZE,
			offset);
	offset += 2;

	cc.enable();
	glVertexAttribPointer(cc.id(), 4, GL_UNSIGNED_BYTE, GL_TRUE, BLOCKSIZE,
			offset);
	offset += 1;

	nn.enable();
	glVertexAttribPointer(nn.id(), 3, GL_SHORT, GL_FALSE, BLOCKSIZE,
			offset);
	offset += 2;

	vv.enable();
	glVertexAttribPointer(vv.id(), 3, GL_FLOAT, GL_FALSE, BLOCKSIZE,
			offset);

	glDisableVertexAttribArray(4);
	glDisableVertexAttribArray(5);
}

void BufferInterleavedTCNV::update(const std::vector<math::vec2f> &tt,
					const std::vector<Color> &cc,
					const std::vector<math::vec3f> &nn,
					const std::vector<math::vec3f> &vv)
{
	unsigned vcnt = static_cast<unsigned>(vv.size());
	int32_t *ildata = new int32_t[BLOCKSIZE / sizeof(int32_t) * vcnt],
					*iter = ildata;

	for(unsigned ii = 0; (ii < vcnt); ++ii)
	{
		float *tptr = reinterpret_cast<float*>(iter);
		tptr[0] = tt[ii].x();
		tptr[1] = tt[ii].y();
		iter += 2;

		uint8_t *cptr = reinterpret_cast<uint8_t*>(iter);
		cptr[0] = static_cast<uint8_t>(cc[ii].r() * 255.0f + 0.5f);
		cptr[1] = static_cast<uint8_t>(cc[ii].g() * 255.0f + 0.5f);
		cptr[2] = static_cast<uint8_t>(cc[ii].b() * 255.0f + 0.5f);
		cptr[3] = static_cast<uint8_t>(cc[ii].a() * 255.0f + 0.5f);
		iter += 1;

		int16_t *nptr = reinterpret_cast<int16_t*>(iter);
		nptr[0] = static_cast<int16_t>(nn[ii].x() * 16384.0f);
		nptr[1] = static_cast<int16_t>(nn[ii].y() * 16384.0f);
		nptr[2] = static_cast<int16_t>(nn[ii].z() * 16384.0f);
		iter += 2;

		float *vptr = reinterpret_cast<float*>(iter);
		vptr[0] = vv[ii].x();
		vptr[1] = vv[ii].y();
		vptr[2] = vv[ii].z();
		iter += 3;
	}

	this->reserve();
	this->bind();
	glBufferData(get_buffer_type(), BLOCKSIZE * vcnt, ildata, GL_STATIC_DRAW);
	delete[] ildata;
}

void BufferInterleavedCNV::feed(const Attribute &cc, const Attribute &nn,
		const Attribute &vv) const
{
	int32_t *offset = NULL;

	this->bind();

	cc.enable();
	glVertexAttribPointer(cc.id(), 4, GL_UNSIGNED_BYTE, GL_TRUE, BLOCKSIZE,
			offset);
	offset += 1;

	nn.enable();
	glVertexAttribPointer(nn.id(), 3, GL_SHORT, GL_FALSE, BLOCKSIZE,
			offset);
	offset += 2;

	vv.enable();
	glVertexAttribPointer(vv.id(), 3, GL_FLOAT, GL_FALSE, BLOCKSIZE,
			offset);

	glDisableVertexAttribArray(3);
	glDisableVertexAttribArray(4);
	glDisableVertexAttribArray(5);
}

void BufferInterleavedCNV::update(const std::vector<Color> &cc,
					const std::vector<math::vec3f> &nn,
					const std::vector<math::vec3f> &vv)
{
	unsigned vcnt = static_cast<unsigned>(vv.size());
	int32_t *ildata = new int32_t[BLOCKSIZE / sizeof(int32_t) * vcnt],
					*iter = ildata;

	for(unsigned ii = 0; (ii < vcnt); ++ii)
	{
		uint8_t *cptr = reinterpret_cast<uint8_t*>(iter);
		cptr[0] = static_cast<uint8_t>(cc[ii].r() * 255.0f + 0.5f);
		cptr[1] = static_cast<uint8_t>(cc[ii].g() * 255.0f + 0.5f);
		cptr[2] = static_cast<uint8_t>(cc[ii].b() * 255.0f + 0.5f);
		cptr[3] = static_cast<uint8_t>(cc[ii].a() * 255.0f + 0.5f);
		iter += 1;

		int16_t *nptr = reinterpret_cast<int16_t*>(iter);
		nptr[0] = static_cast<int16_t>(nn[ii].x() * 16384.0f);
		nptr[1] = static_cast<int16_t>(nn[ii].y() * 16384.0f);
		nptr[2] = static_cast<int16_t>(nn[ii].z() * 16384.0f);
		iter += 2;

		float *vptr = reinterpret_cast<float*>(iter);
		vptr[0] = vv[ii].x();
		vptr[1] = vv[ii].y();
		vptr[2] = vv[ii].z();
		iter += 3;
	}

	this->reserve();
	this->bind();
	glBufferData(get_buffer_type(), BLOCKSIZE * vcnt, ildata, GL_STATIC_DRAW);
	delete[] ildata;
}

void BufferInterleavedTCV::feed(const Attribute &tt, const Attribute &cc,
		const Attribute &vv) const
{
	int32_t *offset = NULL;

	this->bind();

	tt.enable();
	glVertexAttribPointer(tt.id(), 2, GL_FLOAT, GL_FALSE, BLOCKSIZE,
			offset);
	offset += 2;

	cc.enable();
	glVertexAttribPointer(cc.id(), 4, GL_UNSIGNED_BYTE, GL_TRUE, BLOCKSIZE,
			offset);
	offset += 1;

	vv.enable();
	glVertexAttribPointer(vv.id(), 3, GL_FLOAT, GL_FALSE, BLOCKSIZE,
			offset);

	glDisableVertexAttribArray(3);
	glDisableVertexAttribArray(4);
	glDisableVertexAttribArray(5);
}

void BufferInterleavedTCV::update(const std::vector<math::vec2f> &tt,
					const std::vector<Color> &cc,
					const std::vector<math::vec3f> &vv)
{
	unsigned vcnt = static_cast<unsigned>(vv.size());
	int32_t *ildata = new int32_t[BLOCKSIZE / sizeof(int32_t) * vcnt],
					*iter = ildata;

	for(unsigned ii = 0; (ii < vcnt); ++ii)
	{
		float *tptr = reinterpret_cast<float*>(iter);
		tptr[0] = tt[ii].x();
		tptr[1] = tt[ii].y();
		iter += 2;

		uint8_t *cptr = reinterpret_cast<uint8_t*>(iter);
		cptr[0] = static_cast<uint8_t>(cc[ii].r() * 255.0f + 0.5f);
		cptr[1] = static_cast<uint8_t>(cc[ii].g() * 255.0f + 0.5f);
		cptr[2] = static_cast<uint8_t>(cc[ii].b() * 255.0f + 0.5f);
		cptr[3] = static_cast<uint8_t>(cc[ii].a() * 255.0f + 0.5f);
		iter += 1;

		float *vptr = reinterpret_cast<float*>(iter);
		vptr[0] = vv[ii].x();
		vptr[1] = vv[ii].y();
		vptr[2] = vv[ii].z();
		iter += 3;
	}

	this->reserve();
	this->bind();
	glBufferData(get_buffer_type(), BLOCKSIZE * vcnt, ildata, GL_STATIC_DRAW);
	delete[] ildata;
}

void BufferInterleavedTV::feed(const Attribute &tt, const Attribute &vv) const
{
	int32_t *offset = NULL;

	this->bind();

	tt.enable();
	glVertexAttribPointer(tt.id(), 2, GL_FLOAT, GL_FALSE, BLOCKSIZE,
			offset);
	offset += 2;

	vv.enable();
	glVertexAttribPointer(vv.id(), 3, GL_FLOAT, GL_FALSE, BLOCKSIZE,
			offset);

	glDisableVertexAttribArray(2);
	glDisableVertexAttribArray(3);
	glDisableVertexAttribArray(4);
	glDisableVertexAttribArray(5);
}

void BufferInterleavedTV::update(const std::vector<math::vec2f> &tt,
					const std::vector<math::vec3f> &vv)
{
	unsigned vcnt = static_cast<unsigned>(vv.size());
	int32_t *ildata = new int32_t[BLOCKSIZE / sizeof(int32_t) * vcnt],
					*iter = ildata;

	for(unsigned ii = 0; (ii < vcnt); ++ii)
	{
		float *tptr = reinterpret_cast<float*>(iter);
		tptr[0] = tt[ii].x();
		tptr[1] = tt[ii].y();
		iter += 2;

		float *vptr = reinterpret_cast<float*>(iter);
		vptr[0] = vv[ii].x();
		vptr[1] = vv[ii].y();
		vptr[2] = vv[ii].z();
		iter += 3;
	}

	this->reserve();
	this->bind();
	glBufferData(get_buffer_type(), BLOCKSIZE * vcnt, ildata, GL_STATIC_DRAW);
	delete[] ildata;
}

