#include "gfx/entity_object_overlay.hpp"

#include "gfx/surface.hpp"

using namespace gfx;

EntityObjectOverlay::EntityObjectOverlay(const math::vec3d &ppos,
		const math::vec3d &prot) :
	EntityObject(ppos, prot) { }

EntityObjectOverlay::EntityObjectOverlay(const math::vec3d &ppos,
		const math::vec3d &prot, const Mesh *pmesh) :
	EntityObject(ppos, prot, pmesh) { }

EntityObjectOverlay::EntityObjectOverlay(const math::vec3d &ppos,
		const math::vec3d &prot, const std::vector<MeshSptr> &op) :
	EntityObject(ppos, prot, op) { }

EntityObjectOverlay::EntityObjectOverlay(const Mesh *pmesh) :
	EntityObject(pmesh) { }

EntityObjectOverlay::EntityObjectOverlay(const std::vector<MeshSptr> &op) :
	EntityObject(op) { }

math::mat4f EntityObjectOverlay::orient(const math::mat4f &pmat) const
{
	math::mat4f ret = pmat * m_wm;
	load_transform(ret);
	return ret;
}

