#include "gfx/fbo.hpp"

#include "thr/dispatch.hpp"

using namespace gfx;

Fbo::Fbo(unsigned pw, unsigned ph)
{
	thr::wait_privileged(boost::bind(&Fbo::reserve, this, pw, ph));
}

Fbo::~Fbo()
{
	thr::wait_privileged(boost::bind(&Fbo::unreserve, this));
}

void Fbo::bind() const
{
	glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, m_fbo_id);
}

void Fbo::bindTexture(unsigned op) const
{
	glActiveTexture(GL_TEXTURE0 + op);
	glBindTexture(GL_TEXTURE_RECTANGLE_ARB, m_tex_id);
}

void Fbo::reserve(unsigned pw, unsigned ph)
{
	glGenFramebuffersEXT(1, &m_fbo_id);
	glGenTextures(1, &m_tex_id);

	this->bind();

	glBindTexture(GL_TEXTURE_RECTANGLE_ARB, m_tex_id);
	glTexImage2D(GL_TEXTURE_RECTANGLE_ARB, 0, GL_RGBA, pw, ph, 0, GL_RGBA,
			GL_UNSIGNED_BYTE, NULL);

	glFramebufferTexture2DEXT(GL_FRAMEBUFFER_EXT,
			GL_COLOR_ATTACHMENT0_EXT, GL_TEXTURE_RECTANGLE_ARB, m_tex_id, 0);

	this->unbind();
}

void Fbo::unbind() const
{
	glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, 0);
}

void Fbo::unreserve()
{
	glDeleteFramebuffersEXT(1, &m_fbo_id);
	glDeleteTextures(1, &m_tex_id);
}

