#ifndef GFX_FBO_HPP
#define GFX_FBO_HPP

#include "gfx/generic.hpp"

namespace gfx
{
	/** \brief Framebuffer object.
	 *
	 * Used primarily as render-to-texture.
	 */
	class Fbo
	{
		private:
			/** Id for the frame buffer object. */
			GLuint m_fbo_id;

			/** Id for the texture object. */
			GLuint m_tex_id;

			/** Id for the render buffer object. */
			GLuint m_render_id;

		public:
			/** \brief Constructor. */
			Fbo(unsigned pw, unsigned ph);

			/** \brief Destructor. */
			~Fbo();

		public:
			/** \brief Bind this framebuffer object. for use.
			 *
			 * After this call, all drawing will actually happen to the framebuffer
			 * object.
			 */
			void bind() const;

			/** \brief Bind this framebuffer object as a texture.
			 *
			 * @param op Texture unit id (default: 0).
			 */
			void bindTexture(unsigned op = 0) const;

			/** \brief Reserve the resources in this.
			 *
			 * @param pw Width to use for the FBO.
			 * @param ph Heighth to use for the FBO.
			 */
			void reserve(unsigned pw, unsigned ph);

			/** \brief Unbind the buffer object.
			 *
			 * After calling this, all rendering will happen as normal.
			 */
			void unbind() const;

			/** \brief Unreserve the resources in this.
			 */
			void unreserve();
	};
}

#endif
