#ifndef GFX_GENERIC_HPP
#define GFX_GENERIC_HPP

#include "defaults.hpp"

#if defined(__APPLE__)
#include "GL/glew.h"
#include <OpenGL/GL.h>
#include <SDL/SDL.h>
#elif defined(WIN32)
#include "GL/glew.h"
#include "GL/glu.h"
#include "GL/gl.h"
#include "glut.h"
#include "SDL.h"
#else // General *nix such as FreeBSD or Linux.
#include "GL/glew.h"
#include "SDL.h"
#endif

namespace gfx
{
	/** \brief Retrieve GL type.
	 *
	 * Static method for retrieving the OpenGL type.
	 *
	 * @return GLenum corresponding to the instantiated type.
	 */
	template <typename T> inline GLenum get_opengl_type();
	/** \cond */
	template<> inline GLenum get_opengl_type<float>()
	{
		return GL_FLOAT;
	}
	template<> inline GLenum get_opengl_type<int>()
	{
		return GL_INT;
	}
	template<> inline GLenum get_opengl_type<GLuint>()
	{
		return GL_UNSIGNED_INT;
	}
	/** \endcond */

	/** \brief Get OpenGL errors.
	 */
	extern void check_opengl_errors();

	/** \brief Text justification schema.
	 *
	 * Determines how the text is drawn.
	 */
	enum TextJustify
	{
	  /** Text is drawn from left to right starting from the lower left corner
		 * of the first row. */
		LEFT,

		/** Text is drawn aligned to the lower right corner of the first row. */
		CENTER,

		/** Text is drawn as if the coordinates were at the center of the whole
		 * text block, every line centered. */
		RIGHT
	};
}

#endif
