#include "gfx/glyph.hpp"
#include "gfx/font.hpp"

using namespace gfx;

Glyph::Glyph(wchar_t pcode, float pwidth, float pheight, float pleft,
		float ptop, float padvx, float padvy, float ps1, float pt1, float ps2,
		float pt2, unsigned ppage) :
	_code(pcode),
	_width(pwidth),
	_height(pheight),
	_left(pleft),
	_top(ptop),
	_advance(padvx, padvy),
	_st1(ps1, pt1),
	_st2(ps2, pt2),
	_page(ppage)
{
	// Do nothing.
}

void Glyph::compile(const Font &fnt)
{
	_texture = &(fnt.getTexture(_page));
#if 0 //defined(ENABLE_DEBUG)
	std::cout << *this << " ST1: " << _st1 << " ST2: " << _st2 << std::endl;
#endif
}

std::ostream& Glyph::put(std::ostream &ss) const
{
	return ss << "Glyph: " << _code << " / " << _page << " W/H:" <<
		_width << "/" << _height << " L/T:" << _left << "/" << _top << " X/Y:" <<
		_advance.x() << "/" << _advance.y();
}

