#include "gfx/mesh_animated.hpp"

#include <boost/property_tree/ptree.hpp>

using namespace gfx;
namespace pt = boost::property_tree;

MeshAnimated::MeshAnimated(const std::string &pfname) :
	Mesh(pfname) { }

void MeshAnimated::compile()
{
	this->calcNormals();
	m_buf.update(m_bone_ref, m_bone_weight, m_texcoord, m_color, m_normal, m_vertex);
	m_elem.update(m_lod);
	m_lod.compile(m_vertex);
}

void MeshAnimated::draw(const Shader &pshader, const math::mat4f &pmat) const
{
	// TODO: implement
}

void MeshAnimated::unreserve()
{
	m_buf.unreserve();
	this->Mesh::unreserve();
}

