#ifndef GFX_MESH_STATIC_HPP
#define GFX_MESH_STATIC_HPP

#include "gfx/buffer.hpp"
#include "gfx/mesh.hpp"

namespace gfx
{
	/** \brief Static mesh.
	 *
	 * i.e. a mesh which does not animate.
	 */
	class MeshStatic :
		public Mesh
	{
		protected:
			/** Buffer for drawing. */
			BufferInterleavedTCNV m_buf;

		public:
			/** \brief Empty constructor. */
			MeshStatic() { }

			/** \brief Load constructor.
			 *
			 * @param pfname File to load from.
			 */
			MeshStatic(const std::string &pfname);

			/** \brief Destructor. */
			virtual ~MeshStatic() { }

		public:
			/** \cond */
			virtual void compile();
			virtual void draw(const Shader &pshader, const math::mat4f &pmat) const;
			/** \endcond */

		protected:
			/** \cond */
			virtual void unreserve();
			/** \endcond */
	};
}

#endif
