#ifndef GFX_TRIANGLE_HPP
#define GFX_TRIANGLE_HPP

namespace gfx
{
	/** \brief Triangle.
	 *
	 * Contains numeric references, used in meshes as a face elementary type.
	 */
	class Triangle
	{
		private:
			/** References. */
			unsigned _corners[3];

		public:
			/** \brief Empty constructor.
			 *
			 * Only so that STL vector resize() would work.
			 */
			inline Triangle() { }

			/** \brief Constructor.
			 *
			 * @param pa First corner.
			 * @param pb First corner.
			 * @param pc First corner.
			 */
			inline Triangle(unsigned pa, unsigned pb, unsigned pc)
			{
				_corners[0] = pa;
				_corners[1] = pb;
				_corners[2] = pc;
			}

		public:
			/** \brief Get the first corner.
			 *
			 * @return Corner vertex index.
			 */
			inline unsigned& a()
			{
				return _corners[0];
			}

			/** \brief Get the first corner.
			 *
			 * @return Corner vertex index.
			 */
			inline unsigned a() const
			{
				return _corners[0];
			}

			/** \brief Get the second corner.
			 *
			 * @return Corner vertex index.
			 */
			inline unsigned& b()
			{
				return _corners[1];
			}

			/** \brief Get the second corner.
			 *
			 * @return Corner vertex index.
			 */
			inline unsigned b() const
			{
				return _corners[1];
			}

			/** \brief Get the third corner.
			 *
			 * @return Corner vertex index.
			 */
			inline unsigned& c()
			{
				return _corners[2];
			}

			/** \brief Get the third corner.
			 *
			 * @return Corner vertex index.
			 */
			inline unsigned c() const
			{
				return _corners[2];
			}

		public:
			/** \brief Assignment operator.
			 *
			 * @param rhs Right-hand side operand.
			 */
			inline const Triangle& operator=(const Triangle &rhs)
			{
				_corners[0] = rhs.a();
				_corners[1] = rhs.b();
				_corners[2] = rhs.c();
				return *this;
			}

			/** \brief Indexing operator.
			 *
			 * Not checked, idx should be [0, 2].
			 *
			 * @param idx Indexing operator.
			 */
			inline unsigned operator()(unsigned idx)
			{
				return _corners[idx];
			}
	};
};

#endif
