#include <boost/test/unit_test.hpp>

#include "math/vec.hpp"

using namespace math;

namespace
{
	const float tolerance = 0.0001f;
}

#define FLOAT_CHECK_EQUAL(x, y) \
	BOOST_CHECK_CLOSE( (x), (y), tolerance )

BOOST_AUTO_TEST_SUITE( generic )

BOOST_AUTO_TEST_CASE( operations )
{
	FLOAT_CHECK_EQUAL(sqrt(2.0f), 1.414214f);
	FLOAT_CHECK_EQUAL(sqrt(3.0f), 1.732051f);

	FLOAT_CHECK_EQUAL(pow(1.414214f, 2.0f), 2.0f);
	FLOAT_CHECK_EQUAL(pow(2.0f, -0.5f), 0.7071068f);
	FLOAT_CHECK_EQUAL(pow(1.0f, 0.0f), 1.0f);
	FLOAT_CHECK_EQUAL(pow(0.0f, 1.0f), 0.0f);
	FLOAT_CHECK_EQUAL(pow(0.0f, 0.0f), 1.0f);
}

BOOST_AUTO_TEST_SUITE_END()
