#include <boost/test/unit_test.hpp>

#include "math/rect.hpp"

using namespace math;

namespace
{
	const float tolerance = 0.0001f;
}

#define FLOAT_CHECK_EQUAL(x, y) \
	BOOST_CHECK_CLOSE( (x), (y), tolerance )

BOOST_AUTO_TEST_SUITE( rect2 )

BOOST_AUTO_TEST_CASE( constructors_and_accessors )
{
	vec2f vp(1.0f, 0.5f);
	vec2f vs(4.0f, 3.0f);
	rect2f r0(vp, vs);
	FLOAT_CHECK_EQUAL(r0.x1(), 1.0f);
	FLOAT_CHECK_EQUAL(r0.y1(), 0.5f);
	FLOAT_CHECK_EQUAL(r0.w(), 4.0f);
	FLOAT_CHECK_EQUAL(r0.h(), 3.0f);

	rect2f r1(-1.0f, -4.25f, -2.0f, 3.0f);
	FLOAT_CHECK_EQUAL(r1.x1(), -1.0f);
	FLOAT_CHECK_EQUAL(r1.y1(), -4.25f);
	FLOAT_CHECK_EQUAL(r1.w(), -2.0f);
	FLOAT_CHECK_EQUAL(r1.h(), 3.0f);

	rect2f r2(r1); // copy ctor
	FLOAT_CHECK_EQUAL(r2.x1(), -1.0f);
	FLOAT_CHECK_EQUAL(r2.y1(), -4.25f);
	FLOAT_CHECK_EQUAL(r2.w(), -2.0f);
	FLOAT_CHECK_EQUAL(r2.h(), 3.0f);
}

BOOST_AUTO_TEST_CASE( operators )
{
	rect2f r0(-2.0f, -4.25f, 5.0f, 4.25f);
	FLOAT_CHECK_EQUAL(r0.x2(), 3.0f);
	FLOAT_CHECK_EQUAL(r0.y2(), 0.0f);
}

BOOST_AUTO_TEST_CASE( functions )
{
	rect2f r0(-1.0f, -4.25f, 2.0f, 2.0f);
	rect2f r1(-1.5f, -4.0f, 2.0f, 3.5f);
	BOOST_CHECK(r0.overlaps(r1));
	BOOST_CHECK(r1.overlaps(r0));

	rect2f r2(-1.25f, -2.15, 4.0f, 3.0f);
	BOOST_CHECK(!r0.overlaps(r2));
	BOOST_CHECK(!r2.overlaps(r0));
	BOOST_CHECK(r1.overlaps(r2));
	BOOST_CHECK(r2.overlaps(r1));
}

BOOST_AUTO_TEST_SUITE_END()

BOOST_AUTO_TEST_SUITE( rect3 )

BOOST_AUTO_TEST_CASE( constructors_and_accessors )
{
	math::vec3f v0(0.0f, 1.0f, 0.0f);
	
	rect3f r0(v0);
	FLOAT_CHECK_EQUAL(r0.x1(), 0.0f);
	FLOAT_CHECK_EQUAL(r0.y1(), 1.0f);
	FLOAT_CHECK_EQUAL(r0.z1(), 0.0f);
	FLOAT_CHECK_EQUAL(r0.x2(), 0.0f);
	FLOAT_CHECK_EQUAL(r0.y2(), 1.0f);
	FLOAT_CHECK_EQUAL(r0.z2(), 0.0f);

	BOOST_CHECK(r0.getMin() == math::vec3f(0.0f, 1.0f, 0.0f));
	BOOST_CHECK(r0.getMax() == math::vec3f(0.0f, 1.0f, 0.0f));
}

BOOST_AUTO_TEST_CASE( functions_and_operators )
{
	math::vec3f v0(0.0f, 0.0f, 0.0f);
	math::vec3f v1(-65.0f, -90.0f, 4.0f);
	math::vec3f v2(0.5f, 2.0f, -7.0f);
	
	rect3f r0(v0);
	r0.expand(v1);
	r0.expand(v2);

	BOOST_CHECK(r0.getMin() == math::vec3f(-65.0f, -90.0f, -7.0f));
	BOOST_CHECK(r0.getMax() == math::vec3f(0.5f, 2.0f, 4.0f));

	FLOAT_CHECK_EQUAL(r0.x1(), -65.0f);
	FLOAT_CHECK_EQUAL(r0.y1(), -90.0f);
	FLOAT_CHECK_EQUAL(r0.z1(), -7.0f);
	FLOAT_CHECK_EQUAL(r0.x2(), 0.5f);
	FLOAT_CHECK_EQUAL(r0.y2(), 2.0f);
	FLOAT_CHECK_EQUAL(r0.z2(), 4.0f);

	BOOST_CHECK(r0.center() == math::vec3f(-32.25f, -44.0f, -1.5f));
}

BOOST_AUTO_TEST_SUITE_END()
