#ifndef OB_HIGH_SCORE_STATE_HPP
#define OB_HIGH_SCORE_STATE_HPP

#include "ui/ui_state.hpp"
#include "ob_appearing_string.hpp"

namespace ob
{
	/** \brief Menu UI state.
	 */
	class HighScoreState :
		public ui::UiState
	{
		private:
			/** High score list content. */
			std::vector<AppearingStringSptr> m_names;

			/** High score list content. */
			std::vector<AppearingStringSptr> m_scores;

			/** Current offset. */
			float m_offset;

			/** Current movement. */
			float m_movement;

			/** Movement trigger delay. */
			int m_trigger;

			/** Full height. */
			float m_full_height;

			/** Command down. */
			bool m_command_down;

			/** Command up. */
			bool m_command_up;

			/** Index of the newest highscore entry. */
			int m_newest_entry_ind;

		public:
			/** \brief Constructor.
			 *
			 * @param offset Starting offset (default: 0.0f).
			 */
			HighScoreState(float offset = 0.0f);

			/** \brief Destructor. */
			virtual ~HighScoreState() { }

		public:
			/** \cond */
			virtual bool handle(ui::EventKey &ev, ui::UiStack &st);
			virtual bool handle(ui::EventMisc &ev, ui::UiStack &st);
			virtual bool handle(ui::EventMouseButton &ev, ui::UiStack &st);
			virtual bool handle(ui::EventMouseMotion &ev, ui::UiStack &st);
			virtual void update(gfx::SurfaceScreen &screen, ui::UiStack &st, bool prender);
			/** \endcond */

		public:
			/** \brief Render task.
			 */
			void taskRender(gfx::SurfaceScreen &screen) const;
			static void formatHighScore(std::stringstream &sstr, int score);
	};
}

#endif
