#include "ob_visualization_mesh.hpp"

#include "gfx/shader.hpp"
#include "thr/dispatch.hpp"

using namespace ob;

VisualizationMesh::VisualizationMesh(const std::string &pfname)
{
	this->load(pfname);
}

void VisualizationMesh::compile()
{
	thr::dispatch_privileged(boost::bind(&gfx::BufferInterleavedTCV::update,
				&m_buf, boost::ref(m_texcoord), boost::ref(m_color),
				boost::ref(m_vertex)));
	thr::wait_privileged(boost::bind(&Mesh::taskElem, this));
	m_lod.compile(m_vertex);
}

void VisualizationMesh::draw(const gfx::Shader &psh, const math::mat4f &pmat) const
{
	if(!m_textures.empty())
	{
		m_textures[0]->bind(psh.getUniformTex(), 0);
	}

	m_buf.feed(psh.getAttrTexcoord(), psh.getAttrColor(), psh.getAttrVertex());
	m_elem.bind();
	m_lod.draw(pmat);
}

