#ifndef SND_STREAM_HPP
#define SND_STREAM_HPP

#include "snd/sample.hpp"
#include "snd/source.hpp"
#include "thr/generic.hpp"

#include "vorbis/vorbisfile.h"

namespace snd
{
	/** Size for decode buffer in bytes. */
	static const unsigned STREAM_BUFFER_SIZE = 32768;

	/** One audio stream, loaded from a file.
	 */
	class Stream
	{
		private:
			/** Buffer for sound data. */
			char m_buffer[STREAM_BUFFER_SIZE];

			/** Thread. */
			thr::ThreadSptr m_thread;

			/** Private audio source. */
			Source m_source;

			/** Samples. */
			std::list<SampleSptr> m_samples;

			/** Vorbis info structure. */
			vorbis_info *m_vorbis_info;

			/** Vorbis file pointer. */
			OggVorbis_File m_ogg_file;

			/** Quit flag. */
			bool m_stop;

		public:
			/** \brief Constructor.
			 *
			 * @param pfname Filename to load from.
			 */
			Stream(const std::string &pfname);

			/** \brief Destructor. */
			virtual ~Stream();

		public:
			/** \brief Load a file.
			 *
			 * @param pfname Filename to load from.
			 */
			void load(const std::string &pfname);

			/** \brief Thread function. */
			void run();

		public:
			/** \brief What to do at the end of stream?
			 *
			 * Default implementation seeks to the beginning of the stream.
			 *
			 * Alternative implementations could for example quickly load another
			 * file.
			 */
			virtual void eos();
	};

	/** Convenience typedef. */
	typedef boost::shared_ptr<Stream> StreamSptr;
}

#endif
