#ifndef THR_GENERIC_HPP
#define THR_GENERIC_HPP

#include "defaults.hpp"

#include <boost/function.hpp>
#include <boost/thread/thread.hpp>

namespace thr
{
	/** Main thread id. */
	extern boost::thread::id privileged_thread_id;

	/** Convenience typedef. */
	typedef boost::function<void()> Task;

	/** Convenience typedef. */
	typedef boost::shared_ptr<boost::thread> ThreadSptr;

	/** \brief Tell if this is the primary thread.
	 *
	 * If the thread system has not been initialized, will always return false.
	 */
	extern bool is_primary_thread();

	/** \brief Init thread system.
	 *
	 * Sets the privileged thread id unless it's already set, in which case
	 * raises an error.
	 */
	extern void thr_init();

	/** \brief Get a timestamp in microseconds.
	 *
	 * The zero point of the timestamp is unspecified.
	 *
	 * @return Timestamp in microseconds.
	 */
	extern uint64_t usec_get_timestamp();

	/** \brief Sleep an amount of time in microseconds.
	 *
	 * @param op Sleep time in microseconds.
	 */
	extern void usec_sleep(uint64_t op);
}

#endif
