#include "ui/console_state.hpp"

#include "math/random.hpp"
#include "thr/dispatch.hpp"
#include "ui/console.hpp"
#include "ui/ui_stack.hpp"

using namespace ui;

ConsoleState::ConsoleState(Console &pconsole, bool allow_exit) :
	_console(pconsole),
	m_allow_exit_program(allow_exit) { }

bool ConsoleState::handle(EventKey &ev, UiStack &st)
{
	int input_process = _console.getInput().process(ev);
	if(0 > input_process)
	{
		_console.execute();
		return true;
	}
	else if(0 > input_process)
	{
		return true;
	}

	if(ev.isPress())
	{
		switch(ev.getCode())
		{
			case SDLK_KP_MINUS:
				_console.decProgress();
				break;

			case SDLK_KP_PLUS:
				_console.incProgress();
				break;

			case SDLK_ESCAPE:
			case SDLK_WORLD_7:
				// Just disable escape if we're the curren
				if((st.getStateTop() != this) || (st.getNumStates() > 1) ||
						m_allow_exit_program)
				{
					_alive = false;
				}
				break;

			default:
				break;
		}
	}

	return true;
}

bool ConsoleState::handle(EventMisc &ev, UiStack &st)
{
	return true;
}

bool ConsoleState::handle(EventMouseButton &ev, UiStack &st)
{
	return true;
}

bool ConsoleState::handle(EventMouseMotion &ev, UiStack &st)
{
	return true;
}

void ConsoleState::reinstate(UiStack &st)
{
	key_repeat_on();
}

void ConsoleState::taskRender(gfx::SurfaceScreen &screen) const
{
	screen.clear(true, true);
	_console.render(screen);
	screen.update();
}

void ConsoleState::update(gfx::SurfaceScreen &screen, UiStack &st,
		bool prender)
{
	if(prender)
	{
		thr::wait_privileged(boost::bind(&ConsoleState::taskRender, this,
					boost::ref(screen)));
	}
}

