#ifndef UI_CONSOLE_STATE_HPP
#define UI_CONSOLE_STATE_HPP

#include "ui/ui_state.hpp"

namespace ui
{
	class Console;
	class Dispatcher;

	/** \brief Console UI state.
	 *
	 * This is intendended as the base UI state for use with the console. It
	 * includes the basic operations for input, etc.
	 */
	class ConsoleState :
		public UiState
	{
		private:
			/** Referenced console. */
			Console &_console;

			/** Allow quit as last state? */
			bool m_allow_exit_program;

		public:
			/** \brief Constructor.
			 *
			 * @param pconsole Console to attach to.
			 * @param allow_exit Allow ESC if this is the only state?
			 */
			ConsoleState(Console &pconsole, bool allow_exit = true);

			/** \brief Destructor. */
			virtual ~ConsoleState() { }

		public:
			/** \cond */
			virtual bool handle(EventKey &ev, UiStack &st);
			virtual bool handle(EventMisc &ev, UiStack &st);
			virtual bool handle(EventMouseButton &ev, UiStack &st);
			virtual bool handle(EventMouseMotion &ev, UiStack &st);
			virtual void reinstate(UiStack &st);
			virtual void update(gfx::SurfaceScreen &screen, UiStack &st, bool prender);
			/** \endcond */

		public:
			/** \brief Render task.
			 */
			void taskRender(gfx::SurfaceScreen &screen) const;
	};
}

#endif
