#ifndef UI_EVENT_KEY_HPP
#define UI_EVENT_KEY_HPP

#include "ui/event.hpp"

namespace ui
{
	/** \brief Keyboard event.
	 */
	struct EventKey : Event
	{
		/** \brief Constructor.
		 *
		 * @param pcode Keycode.
		 * @param ppress Press flag.
		 */
		inline EventKey(int pcode, bool ppress)
			: Event(KEY)
		{
			_code = pcode;
			_press = ppress;
		}
	};
}

#endif
