#ifndef UI_EVENT_MOUSE_MOTION_HPP
#define UI_EVENT_MOUSE_MOTION_HPP

#include "ui/event.hpp"

namespace ui
{
	/** \brief Mouse motion event.
	 */
	struct EventMouseMotion : Event
	{
		/** \brief Constructor.
		 * 
		 * @param mx Mouse X position.
		 * @param my Mouse Y position.
		 * @param dx Difference X position.
		 * @param dy Difference Y position.
		 */
		inline EventMouseMotion(int mx, int my, int dx, int dy)
			: Event(MOUSE_MOTION)
		{
			_coord.set(mx, my);
			_delta.set(dx, dy);
		}

		/** \brief Alternate constructor.
		 * 
		 * @param pcoord Coordinates.
		 * @param pdelta Delta.
		 */
		inline EventMouseMotion(const math::vec2i &pcoord, const math::vec2i &pdelta)
			: Event(MOUSE_MOTION)
		{
			_coord = pcoord;
			_delta = pdelta;
		}
	};
}

#endif
