#include "ui/text_row.hpp"

#include "ui/text_word.hpp"

using namespace ui;

bool TextRow::add(wchar_t cc, float mwid, float cwid)
{
	if(_width + cwid <= mwid)
	{
		_builder << cc;
		_width += cwid;
		return true;
	}
	return false;
}

bool TextRow::add(const TextWord &word, float mwid, wchar_t schar, float swid)
{
	if(_width + swid + word.getWidth() <= mwid)
	{
		if(0 != schar)
		{
			_builder << schar;
		}
		_builder << word.getContent();
		_width += swid + word.getWidth();
		return true;
	}
	return false;
}

float TextRow::calcWidth(const gfx::Font &fnt, float font_size) const
{
	unsigned nline;
	float ret;

	boost::tie(nline, ret) = fnt.calcLineWidth(font_size, this->getContent());

	return ret;
}

