/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import lonelycoders.ufohippa.client.Client;
import lonelycoders.ufohippa.client.GlobalConfigs;
import lonelycoders.ufohippa.client.InputConfig;
import lonelycoders.ufohippa.client.InputListener;
import lonelycoders.ufohippa.client.Match;
import lonelycoders.ufohippa.client.levels.LevelManager;
import lonelycoders.ufohippa.client.lobby.gui.Lobby;
import lonelycoders.ufohippa.client.renderer.Renderer;
import lonelycoders.ufohippa.client.renderer.gl.OpenGLRenderer;
import lonelycoders.ufohippa.client.resource.ResourceManager;
import lonelycoders.ufohippa.client.sound.EmptySoundManager;
import lonelycoders.ufohippa.client.sound.SoundManager;
import lonelycoders.ufohippa.client.sound.SoundManagerImpl;
import lonelycoders.ufohippa.client.states.GameMenu;
import lonelycoders.ufohippa.client.states.match.ClientMatchStartingState;
import lonelycoders.ufohippa.client.states.match.ClientResultsState;
import lonelycoders.ufohippa.game.GeneralInputAction;
import lonelycoders.ufohippa.game.InputAction;
import lonelycoders.ufohippa.game.PlayerInputAction;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.network.NetworkProtocolException;
import lonelycoders.ufohippa.server.Server;
import lonelycoders.ufohippa.util.ImageUtil;

public class ApplicationFrame
extends JFrame
implements ClientMatchStartingState.Listener,
Client.Listener,
ClientResultsState.Listener {
    private final Lobby lobby;
    private final JComponent gamePanel;
    private final WindowListener closeListener;
    private final Renderer renderer;
    private final List<InputListener> inputListeners = new ArrayList<InputListener>();
    private final InputConfig inputConfig;
    private final ResourceManager resourceManager;
    private final SoundManager soundManager;
    private final LevelManager levelManager = new LevelManager();
    private volatile Client currentClient;
    private Server currentServer;
    private GameMenu gameMenu;
    private Container currentContainer;
    private boolean firstSet = true;

    public ApplicationFrame(Object gameLock) {
        super("Ufohippa 3");
        this.inputConfig = new InputConfig();
        this.closeListener = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ApplicationFrame.this.quit();
            }
        };
        this.addWindowListener(this.closeListener);
        this.setDefaultCloseOperation(2);
        this.resourceManager = new ResourceManager();
        this.renderer = new OpenGLRenderer(gameLock, this.resourceManager);
        this.soundManager = GlobalConfigs.isSoundsEnabled() ? new SoundManagerImpl() : new EmptySoundManager();
        this.lobby = new Lobby(this, gameLock, this.soundManager, this.levelManager);
        this.gamePanel = this.renderer.getComponent();
        try {
            this.setIconImage(ImageUtil.loadImageResource("Icon.png"));
        }
        catch (IOException e) {
            Logger.exception(e);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.registerKeys();
    }

    public void quit() {
        this.soundManager.shutdown();
        System.exit(0);
    }

    private void setActiveMode(Container container, Dimension dimension) {
        boolean fullscreen;
        boolean bl = fullscreen = GlobalConfigs.isFullscreen() || GlobalConfigs.is720p();
        if (fullscreen) {
            Dimension size;
            if (GlobalConfigs.is720p()) {
                size = new Dimension(1280, 720);
            } else {
                GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                size = new Dimension(graphicsDevice.getDisplayMode().getWidth(), graphicsDevice.getDisplayMode().getHeight());
            }
            this.getContentPane().removeAll();
            this.getContentPane().add((Component)container, "Center");
            if (this.firstSet) {
                this.setUndecorated(true);
                this.setSize(size);
                this.setLocation(0, 0);
                this.setVisible(true);
                this.firstSet = false;
                this.addWindowListener(this.closeListener);
            } else {
                this.getContentPane().invalidate();
                this.getContentPane().validate();
            }
            this.currentContainer = container;
        } else {
            if (container != this.currentContainer) {
                this.removeWindowListener(this.closeListener);
                this.setVisible(false);
                GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                this.getContentPane().removeAll();
                this.getContentPane().add((Component)container, "Center");
                if (dimension != null) {
                    this.setSize(dimension);
                } else {
                    this.pack();
                }
                this.setLocationRelativeTo(null);
                this.addWindowListener(this.closeListener);
                this.setVisible(true);
            }
            this.currentContainer = container;
        }
    }

    public void setMenuActive(boolean reset) {
        if (reset) {
            this.currentServer = null;
            if (this.currentClient != null) {
                this.unregisterClient(this.currentClient);
            }
            this.lobby.reset();
        }
        this.setActiveMode(this.lobby, null);
        this.soundManager.playMenuMusic();
    }

    public void setGameActive() {
        this.renderer.clear();
        this.setActiveMode(this.gamePanel, null);
        this.renderer.waitForActive();
    }

    private void registerKeys() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){
            private int lastKey = 0;

            @Override
            public void eventDispatched(AWTEvent event) {
                boolean pressed;
                if (ApplicationFrame.this.gameMenu != null) {
                    return;
                }
                KeyEvent keyEvent = (KeyEvent)event;
                int id = keyEvent.getID();
                if (id == 401) {
                    pressed = true;
                } else if (id == 402) {
                    pressed = false;
                } else {
                    return;
                }
                int keyCode = keyEvent.getKeyCode();
                InputAction action = ApplicationFrame.this.inputConfig.getAction(keyCode);
                if (action == null) {
                    return;
                }
                Logger.detail("KeyEvent " + keyEvent.paramString());
                if (!pressed || keyCode != this.lastKey) {
                    if (action instanceof PlayerInputAction) {
                        PlayerInputAction playerInputAction = (PlayerInputAction)action;
                        for (InputListener inputListener : ApplicationFrame.this.inputListeners) {
                            inputListener.setInputActionState(playerInputAction, pressed);
                        }
                    } else if (action instanceof GeneralInputAction && pressed) {
                        if (action == GeneralInputAction.CONTINUE || action == GeneralInputAction.CONTINUE_ALT) {
                            for (InputListener inputListener : ApplicationFrame.this.inputListeners) {
                                inputListener.continuePressed();
                            }
                        } else if (action == GeneralInputAction.MENU && ApplicationFrame.this.currentClient != null && ApplicationFrame.this.currentClient.getManager().getMatchState().isActiveState()) {
                            ApplicationFrame.this.gameMenuTriggered();
                        }
                    }
                    this.lastKey = pressed ? keyCode : 0;
                }
            }
        }, 8L);
    }

    private void gameMenuTriggered() {
        if (this.gameMenu == null) {
            GameMenu.Action returnAction = new GameMenu.Action("Return to game"){

                @Override
                protected void doAction() {
                }
            };
            GameMenu.Action exitAction = new GameMenu.Action("Exit to menu"){

                @Override
                protected void doAction() {
                    Server server = ApplicationFrame.this.currentServer;
                    Client client = ApplicationFrame.this.currentClient;
                    if (server != null) {
                        int value;
                        if (!server.isLocalGame() && (value = JOptionPane.showConfirmDialog(ApplicationFrame.this, "You have other clients connected to the game.\nExiting to menu will disconnect all clients.", "Confirm close server", 2, 2)) != 0) {
                            return;
                        }
                        ApplicationFrame.this.setMenuActive(true);
                        server.close();
                    } else if (client != null) {
                        ApplicationFrame.this.setMenuActive(true);
                        client.disconnect();
                    }
                }
            };
            this.gameMenu = new GameMenu(this, returnAction, exitAction);
            this.gameMenu.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    ApplicationFrame.this.gameMenu = null;
                }
            });
            this.gameMenu.setLocationRelativeTo(this);
            this.gameMenu.setVisible(true);
        }
    }

    @Override
    public void matchStarting() {
        this.setGameActive();
    }

    @Override
    public void matchReady(Match match) {
        this.renderer.initialize(match);
    }

    @Override
    public void waitForReady() {
        while (!this.resourceManager.getResourceLoader().isFinished()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Logger.exception(e);
            }
        }
    }

    @Override
    public void matchEnded() {
        if (this.currentServer != null) {
            this.currentServer.start();
        }
        this.setMenuActive(false);
    }

    public void addInputListener(InputListener inputListener) {
        this.inputListeners.add(inputListener);
    }

    public void registerServer(Server server) {
        this.currentServer = server;
    }

    public void registerClient(Client client) {
        this.currentClient = client;
        client.getManager().getMatchState().getResultsState().addListener(this);
        client.getManager().getMatchState().getMatchStartingState().addListener(this);
        this.addInputListener(client.getManager().getMatchState().getRoundState());
        this.addInputListener(client.getManager().getMatchState().getResultsState());
    }

    public void unregisterClient(Client client) {
        this.currentClient = null;
        this.inputListeners.clear();
    }

    @Override
    public void clientDisconnected(NetworkProtocolException e) {
        if (this.currentClient != null) {
            this.setMenuActive(true);
            String message = "Connection to the server was lost.";
            if (e.isBug()) {
                message = message + "\nThere was an unexpected error in communication protocol.";
                Logger.exception(e);
            }
            JOptionPane.showMessageDialog(this, message, "Disconnected", 1);
        }
    }
}

