/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import lonelycoders.ufohippa.client.levels.LevelManager;
import lonelycoders.ufohippa.client.lobby.model.AllMatchSettings;
import lonelycoders.ufohippa.client.sound.SoundManager;
import lonelycoders.ufohippa.client.states.ClientStateManager;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.network.CommandSender;
import lonelycoders.ufohippa.network.NetworkProtocolException;

public class Client {
    private final String name;
    private final Listener listener;
    private final ClientStateManager stateManager;
    private final AllMatchSettings allMatchSettings;
    private Socket socket;
    private CommandSender commandSender;

    public Client(SoundManager soundManager, LevelManager levelManager, String name, Object gameLock, Listener listener) {
        this.name = name;
        this.listener = listener;
        this.allMatchSettings = new AllMatchSettings();
        this.stateManager = new ClientStateManager(soundManager, levelManager, this.allMatchSettings, gameLock);
    }

    public void connect(InetAddress address, int port) throws IOException {
        try {
            this.socket = new Socket(address, port);
            this.commandSender = new SocketHandler(this.socket);
        }
        catch (NetworkProtocolException e) {
            Logger.exception(e);
            throw new IOException("Connection failed");
        }
    }

    public ClientStateManager getManager() {
        return this.stateManager;
    }

    public AllMatchSettings getAllMatchSettings() {
        return this.allMatchSettings;
    }

    public void waitForReady() {
        this.commandSender.waitForReady();
    }

    public void disconnect() {
        if (this.socket.isConnected()) {
            try {
                Logger.info("Closing connection");
                this.socket.close();
            }
            catch (IOException e) {
                Logger.exception(e);
            }
        }
    }

    public static interface Listener {
        public void clientDisconnected(NetworkProtocolException var1);
    }

    private class SocketHandler
    extends CommandSender
    implements Runnable {
        private final Socket socket;
        private boolean alive;
        private final DataInputStream dis;
        private final DataOutputStream dos;

        public SocketHandler(Socket socket) throws NetworkProtocolException {
            super("Client handler sender");
            this.alive = true;
            this.socket = socket;
            try {
                this.dis = new DataInputStream(socket.getInputStream());
                this.dos = new DataOutputStream(socket.getOutputStream());
            }
            catch (IOException e) {
                throw new NetworkProtocolException(e);
            }
            try {
                Client.this.stateManager.connected(this);
            }
            catch (NetworkProtocolException e) {
                Logger.exception(e);
                this.alive = false;
            }
            Thread thread = new Thread((Runnable)this, Client.this.name + " handler");
            thread.start();
        }

        @Override
        public void run() {
            while (this.alive) {
                try {
                    Client.this.stateManager.readCommand(this.dis);
                }
                catch (NetworkProtocolException e) {
                    this.exceptionCaught(e);
                }
            }
            try {
                this.socket.close();
            }
            catch (IOException e) {
                Logger.exception(e);
            }
        }

        @Override
        public String getTarget() {
            return "server";
        }

        @Override
        public DataOutputStream getDataOutputStream() {
            return this.dos;
        }

        @Override
        public void exceptionCaught(NetworkProtocolException e) {
            this.alive = false;
            Client.this.commandSender.stop();
            try {
                if (this.socket.isConnected()) {
                    this.socket.close();
                }
            }
            catch (IOException e1) {
                Logger.exception(e1);
            }
            Client.this.listener.clientDisconnected(e);
        }
    }
}

