/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client;

import java.util.Map;
import lonelycoders.ufohippa.client.states.match.Player;
import lonelycoders.ufohippa.game.Round;
import lonelycoders.ufohippa.game.RoundResults;
import lonelycoders.ufohippa.game.level.Level;

public class Match {
    private final Map<String, Player> players;
    private final Level[] levels;
    private State state = State.NONE;
    private Round currentRound;
    private RoundResults roundResults;
    private int roundNumber;

    public Match(Map<String, Player> players, Level[] levels) {
        this.players = players;
        this.levels = levels;
    }

    public void startRound(Round round, int roundNumber) {
        this.roundNumber = roundNumber;
        this.state = State.ROUND;
        this.currentRound = round;
    }

    public State getState() {
        return this.state;
    }

    public Level[] getLevels() {
        return this.levels;
    }

    public int getCurrentRoundNumber() {
        return this.roundNumber;
    }

    public Round getCurrentRound() {
        return this.currentRound;
    }

    public void showResults(RoundResults roundResults) {
        this.roundResults = roundResults;
        this.state = State.ROUND_RESULTS;
    }

    public boolean nextResults() {
        if (this.state == State.ROUND_RESULTS) {
            this.state = State.MATCH_RESULTS;
            return false;
        }
        if (this.state == State.MATCH_RESULTS) {
            if (this.roundNumber == this.levels.length - 1) {
                this.state = State.END_RESULTS;
                return false;
            }
            this.state = State.WAITING;
            return true;
        }
        if (this.state == State.END_RESULTS) {
            this.state = State.WAITING;
            return true;
        }
        assert (false);
        return false;
    }

    public RoundResults getRoundResults() {
        return this.roundResults;
    }

    public Map<String, Player> getPlayers() {
        return this.players;
    }

    public static enum State {
        NONE,
        LOADING,
        WAITING,
        ROUND,
        ROUND_RESULTS,
        MATCH_RESULTS,
        END_RESULTS;

    }
}

