/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.gl;

import java.util.HashMap;
import lonelycoders.ufohippa.client.gl.Mesh;
import lonelycoders.ufohippa.client.gl.Quad;
import lonelycoders.ufohippa.client.gl.Triangle;
import lonelycoders.ufohippa.client.gl.Vertex;
import lonelycoders.ufohippa.game.util.Vector2;
import lonelycoders.ufohippa.game.util.Vector3;

public class MeshUtil {
    public static Mesh createQuad() {
        Vertex[] corners = new Vertex[]{new Vertex(new Vector3(0.0f, 0.0f, 0.0f), new Vector2(0.0f, 0.0f)), new Vertex(new Vector3(1.0f, 0.0f, 0.0f), new Vector2(1.0f, 0.0f)), new Vertex(new Vector3(0.0f, 1.0f, 0.0f), new Vector2(0.0f, 1.0f)), new Vertex(new Vector3(1.0f, 1.0f, 0.0f), new Vector2(1.0f, 1.0f))};
        Quad[] quads = new Quad[]{new Quad(corners[0], corners[1], corners[3], corners[2], new Vector3(0.0f, 0.0f, 1.0f))};
        return new Mesh(quads);
    }

    public static Mesh createCube() {
        Vertex[] corners = new Vertex[]{new Vertex(new Vector3(0.0f, 0.0f, 0.0f), new Vector2(0.0f, 0.0f)), new Vertex(new Vector3(1.0f, 0.0f, 0.0f), new Vector2(1.0f, 0.0f)), new Vertex(new Vector3(0.0f, 1.0f, 0.0f), new Vector2(0.0f, 1.0f)), new Vertex(new Vector3(1.0f, 1.0f, 0.0f), new Vector2(1.0f, 1.0f)), new Vertex(new Vector3(0.0f, 0.0f, 1.0f), new Vector2(0.0f, 0.0f)), new Vertex(new Vector3(1.0f, 0.0f, 1.0f), new Vector2(1.0f, 0.0f)), new Vertex(new Vector3(0.0f, 1.0f, 1.0f), new Vector2(0.0f, 1.0f)), new Vertex(new Vector3(1.0f, 1.0f, 1.0f), new Vector2(1.0f, 1.0f))};
        Quad[] quads = new Quad[]{new Quad(corners[1], corners[0], corners[2], corners[3], new Vector3(0.0f, 0.0f, -1.0f)), new Quad(corners[0], corners[4], corners[6], corners[2], new Vector3(-1.0f, 0.0f, 0.0f)), new Quad(corners[4], corners[5], corners[7], corners[6], new Vector3(0.0f, 0.0f, 1.0f)), new Quad(corners[5], corners[1], corners[3], corners[7], new Vector3(1.0f, 0.0f, 0.0f)), new Quad(corners[6], corners[7], corners[3], corners[2], new Vector3(0.0f, 1.0f, 0.0f)), new Quad(corners[0], corners[1], corners[5], corners[4], new Vector3(0.0f, -1.0f, 0.0f))};
        return new Mesh(quads);
    }

    public static Mesh createRoundedCube(float roundness) {
        return MeshUtil.createRoundedCube(1.0f, 1.0f, 1.0f, roundness);
    }

    public static Mesh createRoundedCube(float width, float height, float depth, float roundness) {
        float MIN = roundness;
        float MAX = 1.0f - MIN;
        float MINW = MIN;
        float MINH = MIN;
        float MIND = MIN;
        float MAXW = width - MIN;
        float MAXH = height - MIN;
        float MAXD = depth - MIN;
        Vector3 frontNormal = new Vector3(0.0f, 0.0f, 1.0f);
        Vector3 backNormal = new Vector3(0.0f, 0.0f, -1.0f);
        Vector3 topNormal = new Vector3(0.0f, 1.0f, 0.0f);
        Vector3 bottomNormal = new Vector3(0.0f, -1.0f, 0.0f);
        Vector3 leftNormal = new Vector3(-1.0f, 0.0f, 0.0f);
        Vector3 rightNormal = new Vector3(1.0f, 0.0f, 0.0f);
        Quad back = new Quad(new Vertex(new Vector3(MAXW, MINH, 0.0f), new Vector2(MAX, MIN), backNormal), new Vertex(new Vector3(MINW, MINH, 0.0f), new Vector2(MIN, MIN), backNormal), new Vertex(new Vector3(MINW, MAXH, 0.0f), new Vector2(MIN, MAX), backNormal), new Vertex(new Vector3(MAXW, MAXH, 0.0f), new Vector2(MAX, MAX), backNormal), backNormal);
        Quad front = new Quad(new Vertex(new Vector3(MINW, MINH, depth), new Vector2(MIN, MIN), frontNormal), new Vertex(new Vector3(MAXW, MINH, depth), new Vector2(MAX, MIN), frontNormal), new Vertex(new Vector3(MAXW, MAXH, depth), new Vector2(MAX, MAX), frontNormal), new Vertex(new Vector3(MINW, MAXH, depth), new Vector2(MIN, MAX), frontNormal), frontNormal);
        Quad left = new Quad(new Vertex(new Vector3(0.0f, MINH, MIND), new Vector2(0.0f, MIN), leftNormal), new Vertex(new Vector3(0.0f, MINH, MAXD), new Vector2(0.0f, MIN), leftNormal), new Vertex(new Vector3(0.0f, MAXH, MAXD), new Vector2(0.0f, MAX), leftNormal), new Vertex(new Vector3(0.0f, MAXH, MIND), new Vector2(0.0f, MAX), leftNormal), leftNormal);
        Quad right = new Quad(new Vertex(new Vector3(width, MINH, MAXD), new Vector2(1.0f, MIN), leftNormal), new Vertex(new Vector3(width, MINH, MIND), new Vector2(1.0f, MIN), leftNormal), new Vertex(new Vector3(width, MAXH, MIND), new Vector2(1.0f, MAX), leftNormal), new Vertex(new Vector3(width, MAXH, MAXD), new Vector2(1.0f, MAX), leftNormal), rightNormal);
        Quad bottom = new Quad(new Vertex(new Vector3(MAXW, 0.0f, MAXD), new Vector2(MAX, 0.0f), bottomNormal), new Vertex(new Vector3(MINW, 0.0f, MAXD), new Vector2(MIN, 0.0f), bottomNormal), new Vertex(new Vector3(MINW, 0.0f, MIND), new Vector2(MIN, 0.0f), bottomNormal), new Vertex(new Vector3(MAXW, 0.0f, MIND), new Vector2(MAX, 0.0f), bottomNormal), bottomNormal);
        Quad top = new Quad(new Vertex(new Vector3(MINW, height, MAXD), new Vector2(MIN, 1.0f), topNormal), new Vertex(new Vector3(MAXW, height, MAXD), new Vector2(MAX, 1.0f), topNormal), new Vertex(new Vector3(MAXW, height, MIND), new Vector2(MAX, 1.0f), topNormal), new Vertex(new Vector3(MINW, height, MIND), new Vector2(MIN, 1.0f), topNormal), topNormal);
        Quad[] faces = new Quad[]{back, front, left, right, bottom, top};
        Quad[] edges = new Quad[]{new Quad(front.getV4(), front.getV3(), top.getV2(), top.getV1()), new Quad(front.getV2(), front.getV1(), bottom.getV2(), bottom.getV1()), new Quad(front.getV1(), front.getV4(), left.getV3(), left.getV2()), new Quad(front.getV3(), front.getV2(), right.getV1(), right.getV4()), new Quad(back.getV4(), back.getV3(), top.getV4(), top.getV3()), new Quad(back.getV2(), back.getV1(), bottom.getV4(), bottom.getV3()), new Quad(back.getV3(), back.getV2(), left.getV1(), left.getV4()), new Quad(back.getV1(), back.getV4(), right.getV3(), right.getV2()), new Quad(left.getV4(), left.getV3(), top.getV1(), top.getV4()), new Quad(top.getV3(), top.getV2(), right.getV4(), right.getV3()), new Quad(right.getV2(), right.getV1(), bottom.getV1(), bottom.getV4()), new Quad(bottom.getV3(), bottom.getV2(), left.getV2(), left.getV1())};
        Triangle[] corners = new Triangle[]{new Triangle(front.getV1(), left.getV2(), bottom.getV2()), new Triangle(front.getV2(), bottom.getV1(), right.getV1()), new Triangle(front.getV3(), right.getV4(), top.getV2()), new Triangle(front.getV4(), top.getV1(), left.getV3()), new Triangle(back.getV1(), right.getV2(), bottom.getV4()), new Triangle(back.getV2(), bottom.getV3(), left.getV1()), new Triangle(back.getV3(), left.getV4(), top.getV4()), new Triangle(back.getV4(), top.getV3(), right.getV3())};
        Triangle[] allTriangles = MeshUtil.merge(MeshUtil.splitQuads(faces), MeshUtil.splitQuads(edges), corners);
        return new Mesh(allTriangles);
    }

    public static Triangle[] merge(Triangle[] ... allTriangles) {
        int triangleCount = 0;
        for (Triangle[] triangles : allTriangles) {
            triangleCount += triangles.length;
        }
        Triangle[] newTriangles = new Triangle[triangleCount];
        int i = 0;
        for (Triangle[] triangles : allTriangles) {
            System.arraycopy(triangles, 0, newTriangles, i, triangles.length);
            i += triangles.length;
        }
        return newTriangles;
    }

    public static Triangle[] mirrorHorizontal(Triangle ... triangles) {
        return MeshUtil.mirror(triangles, true);
    }

    public static Triangle[] mirrorVertical(Triangle ... triangles) {
        return MeshUtil.mirror(triangles, false);
    }

    private static Triangle[] mirror(Triangle[] triangles, boolean horizontal) {
        HashMap<Vertex, Vertex> mirroredVertices = new HashMap<Vertex, Vertex>();
        Triangle[] newTriangles = new Triangle[triangles.length];
        int trianglesLength = triangles.length;
        for (int i = 0; i < trianglesLength; ++i) {
            Triangle triangle = triangles[i];
            for (Vertex vertex : triangle.getVertices()) {
                Vector3 newNormal;
                Vector3 newPosition;
                if (mirroredVertices.containsKey(vertex)) continue;
                Vector3 position = vertex.getPosition();
                Vector3 normal = vertex.getNormal();
                if (horizontal) {
                    newPosition = new Vector3(-position.x, position.y, position.z);
                    newNormal = new Vector3(-normal.x, normal.y, normal.z);
                } else {
                    newPosition = new Vector3(position.x, -position.y, position.z);
                    newNormal = new Vector3(normal.x, -normal.y, normal.z);
                }
                mirroredVertices.put(vertex, new Vertex(newPosition, vertex.getTextureCoordinates(), newNormal));
            }
            newTriangles[i] = new Triangle((Vertex)mirroredVertices.get(triangle.getV3()), (Vertex)mirroredVertices.get(triangle.getV2()), (Vertex)mirroredVertices.get(triangle.getV1()));
        }
        return MeshUtil.merge(triangles, newTriangles);
    }

    public static Triangle[] splitQuads(Quad ... quads) {
        Triangle[] triangles = new Triangle[quads.length * 2];
        for (int i = 0; i < quads.length; ++i) {
            Triangle[] pair = quads[i].toTriangles();
            triangles[i * 2] = pair[0];
            triangles[i * 2 + 1] = pair[1];
        }
        return triangles;
    }
}

