/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.gl;

import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL;
import lonelycoders.ufohippa.client.gl.MeshGL;
import lonelycoders.ufohippa.client.gl.Shader;
import lonelycoders.ufohippa.client.gl.UtilGL;
import lonelycoders.ufohippa.client.gl.texturing.Texture;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.game.util.Vector3;

public class RenderOptimizer {
    private final GL gl;
    private RenderState currentState = new RenderState();
    private final Map<Shader, ShaderData> currentShaders;
    private RenderState previousState = new RenderState();

    public RenderOptimizer(GL gl) {
        this.currentShaders = new HashMap<Shader, ShaderData>();
        this.gl = gl;
    }

    private ShaderData getShaderData(Shader shader) {
        if (!this.currentShaders.containsKey(shader)) {
            this.currentShaders.put(shader, new ShaderData(shader));
        }
        return this.currentShaders.get(shader);
    }

    public void bindTexture(Texture texture, Shader shader, String textureUniform) {
        this.currentState.texture = texture;
        ShaderData shaderData = this.getShaderData(shader);
        this.currentState.shader = shaderData;
        shaderData.applyUniform(textureUniform, texture);
    }

    public void setColor(ColorRGB color) {
        this.currentState.color = color;
    }

    public void unbindTexture(Texture texture) {
        this.currentState.texture = null;
    }

    public void applyUniform(Shader shader, String uniform, float value) {
        this.getShaderData(shader).applyUniform(uniform, value);
    }

    public void drawMesh(MeshGL mesh, Vector3 offset) {
        this.currentState.offset = offset;
        this.currentState.mesh = mesh;
        this.currentState.customDrawable = null;
        this.enqueueRender();
    }

    public void drawCustom(Drawable customDrawable, Vector3 offset) {
        this.currentState.offset = offset;
        this.currentState.mesh = null;
        this.currentState.customDrawable = customDrawable;
        this.enqueueRender();
    }

    private void enqueueRender() {
        this.currentState.render(this.gl, this.previousState);
        this.previousState = new RenderState(this.currentState);
    }

    public void flush() {
    }

    public static interface Drawable {
        public void render(GL var1);
    }

    private static class ShaderData {
        private final Shader shader;
        private Texture texture;
        private float floatValue;

        public ShaderData(Shader shader) {
            this.shader = shader;
        }

        public ShaderData(ShaderData original) {
            this.shader = original.shader;
            this.texture = original.texture;
            this.floatValue = original.floatValue;
        }

        public void applyUniform(String uniform, Texture texture) {
            this.texture = texture;
        }

        public void applyUniform(String uniform, float value) {
            this.floatValue = value;
        }

        public void bind(GL gl, ShaderData currentShader) {
            if (currentShader == null || this.shader != currentShader.shader) {
                this.shader.bind(gl);
            }
            if (currentShader == null || this.texture != currentShader.texture) {
                this.texture.bind(gl, this.shader, "texture");
            }
            if (currentShader == null || this.floatValue != currentShader.floatValue) {
                this.shader.applyUniform(gl, "ufoFactor", this.floatValue);
            }
        }
    }

    private static class RenderState {
        private ColorRGB color;
        private Texture texture;
        private ShaderData shader;
        private Drawable customDrawable;
        public Vector3 offset;
        public MeshGL mesh;

        public RenderState() {
        }

        public RenderState(RenderState original) {
            this.color = original.color;
            this.texture = original.texture;
            this.shader = new ShaderData(original.shader);
            this.customDrawable = original.customDrawable;
            this.offset = new Vector3(original.offset);
            this.mesh = original.mesh;
        }

        public void render(GL gl, RenderState currentState) {
            if (this.color != null && this.color != currentState.color) {
                UtilGL.applyColor(gl, this.color);
            }
            if (this.shader != null) {
                this.shader.bind(gl, currentState.shader);
            }
            gl.glTranslatef(this.offset.x, this.offset.y, this.offset.z);
            if (this.customDrawable != null) {
                this.customDrawable.render(gl);
            } else {
                this.mesh.render(gl);
            }
            gl.glTranslatef(-this.offset.x, -this.offset.y, -this.offset.z);
        }
    }
}

