/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.gl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.media.opengl.GL;
import lonelycoders.ufohippa.client.resource.ResourceGL;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.game.util.ColorRGBA;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.util.ResourceUtil;

public class Shader
implements ResourceGL {
    private int shaderProgram = -1;
    private final ShaderLoader loader;
    private ShaderInfo shaderInfo;

    private Shader(ShaderLoader loader) {
        this.loader = loader;
    }

    public Shader(final String[] vertexShaderCode, final String[] fragmentShaderCode, final String shaderName, final String vertexShaderName, final String fragmentShaderName) {
        this(new ShaderLoader(){

            @Override
            public ShaderInfo load() {
                return new ShaderInfo(shaderName, vertexShaderCode, fragmentShaderCode, vertexShaderName, fragmentShaderName);
            }
        });
    }

    public Shader(final String shaderName) {
        this(new ShaderLoader(){

            @Override
            public ShaderInfo load() {
                try {
                    String[] vertexCode = Shader.getShaderCode(shaderName + ".vert");
                    String[] fragmentCode = Shader.getShaderCode(shaderName + ".frag");
                    return new ShaderInfo(shaderName, vertexCode, fragmentCode);
                }
                catch (IOException e) {
                    Logger.exception(e);
                    return null;
                }
            }
        });
    }

    @Override
    public void load() {
        this.shaderInfo = this.loader.load();
    }

    @Override
    public void loadGl(GL gl) {
        int vertexShaderId = Shader.createShader(gl, this.shaderInfo.vertexShaderCode, 35633, this.shaderInfo.vertexShaderName);
        int fragmentShaderId = Shader.createShader(gl, this.shaderInfo.fragmentShaderCode, 35632, this.shaderInfo.fragmentShaderName);
        this.shaderProgram = Shader.createShaderProgram(gl, vertexShaderId, fragmentShaderId, this.shaderInfo.shaderName);
    }

    private void createShaders(GL gl, String[] vertexShaderCode, String[] fragmentShaderCode, String shaderName, String vertexShaderName, String fragmentShaderName) {
        int vertexShaderId = Shader.createShader(gl, vertexShaderCode, 35633, vertexShaderName);
        int fragmentShaderId = Shader.createShader(gl, fragmentShaderCode, 35632, fragmentShaderName);
        this.shaderProgram = Shader.createShaderProgram(gl, vertexShaderId, fragmentShaderId, shaderName);
    }

    private static int createShader(GL gl, String[] code, int type, String fileName) {
        int id = gl.glCreateShader(type);
        gl.glShaderSource(id, code.length, code, null);
        gl.glCompileShader(id);
        int[] compiled = new int[1];
        gl.glGetShaderiv(id, 35713, compiled, 0);
        if (compiled[0] != 1) {
            int[] logLength = new int[1];
            gl.glGetShaderiv(id, 35716, logLength, 0);
            byte[] log = new byte[logLength[0]];
            gl.glGetShaderInfoLog(id, logLength[0], new int[1], 0, log, 0);
            System.err.println("Shader \"" + fileName + "\" compilation failed: " + new String(log));
        }
        return id;
    }

    private static int createShaderProgram(GL gl, int vertexShaderId, int fragmentShaderId, String shaderName) {
        int id = gl.glCreateProgram();
        gl.glAttachShader(id, vertexShaderId);
        gl.glAttachShader(id, fragmentShaderId);
        gl.glLinkProgram(id);
        int[] linked = new int[1];
        gl.glGetProgramiv(id, 35714, linked, 0);
        if (linked[0] != 1) {
            int[] logLength = new int[1];
            gl.glGetProgramiv(id, 35716, logLength, 0);
            byte[] log = new byte[logLength[0]];
            gl.glGetProgramInfoLog(id, logLength[0], new int[1], 0, log, 0);
            System.err.println("Shader program \"" + shaderName + "\" linking failed: " + new String(log));
        }
        gl.glValidateProgram(id);
        int[] validated = new int[1];
        gl.glGetProgramiv(id, 35715, validated, 0);
        if (validated[0] != 1) {
            int[] logLength = new int[1];
            gl.glGetProgramiv(id, 35716, logLength, 0);
            byte[] log = new byte[logLength[0]];
            gl.glGetProgramInfoLog(id, logLength[0], new int[1], 0, log, 0);
            System.err.println("Shader program \"" + shaderName + "\" validation failed: " + new String(log));
        }
        return id;
    }

    public static String[] getShaderCode(String resourceName) throws IOException {
        String line;
        InputStream is = ResourceUtil.getResource(resourceName);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            lines.add(line + "\n");
        }
        return lines.toArray(new String[lines.size()]);
    }

    public void bind(GL gl) {
        assert (this.shaderProgram != -1);
        gl.glUseProgram(this.shaderProgram);
    }

    public void unbind(GL gl) {
        gl.glUseProgram(0);
    }

    public void applyUniform(GL gl, String uniformName, int value) {
        int location = gl.glGetUniformLocation(this.shaderProgram, uniformName);
        gl.glUniform1i(location, value);
    }

    public void applyUniform(GL gl, String uniformName, float value) {
        int location = gl.glGetUniformLocation(this.shaderProgram, uniformName);
        gl.glUniform1f(location, value);
    }

    public void applyUniform(GL gl, String uniformName, double value) {
        int location = gl.glGetUniformLocation(this.shaderProgram, uniformName);
        gl.glUniform1f(location, (float)value);
    }

    public void applyUniform(GL gl, String uniformName, ColorRGB value) {
        int location = gl.glGetUniformLocation(this.shaderProgram, uniformName);
        gl.glUniform3f(location, value.getRed(), value.getGreen(), value.getBlue());
    }

    public void applyUniform(GL gl, String uniformName, ColorRGBA value) {
        int location = gl.glGetUniformLocation(this.shaderProgram, uniformName);
        gl.glUniform4f(location, value.getRed(), value.getGreen(), value.getBlue(), value.getAlpha());
    }

    private static interface ShaderLoader {
        public ShaderInfo load();
    }

    private static class ShaderInfo {
        public final String shaderName;
        public final String[] vertexShaderCode;
        public final String[] fragmentShaderCode;
        public final String vertexShaderName;
        public final String fragmentShaderName;

        private ShaderInfo(String shaderName, String[] vertexShaderCode, String[] fragmentShaderCode, String vertexShaderName, String fragmentShaderName) {
            this.shaderName = shaderName;
            this.vertexShaderCode = vertexShaderCode;
            this.fragmentShaderCode = fragmentShaderCode;
            this.vertexShaderName = vertexShaderName;
            this.fragmentShaderName = fragmentShaderName;
        }

        private ShaderInfo(String shaderName, String[] vertexShaderCode, String[] fragmentShaderCode) {
            this(shaderName, vertexShaderCode, fragmentShaderCode, shaderName + ".vert", shaderName + ".frag");
        }
    }
}

