/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.gl;

import com.sun.opengl.util.BufferUtil;
import java.awt.Dimension;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import lonelycoders.ufohippa.client.gl.GLException;
import lonelycoders.ufohippa.client.gl.texturing.Texture;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.game.util.ColorRGBA;
import lonelycoders.ufohippa.game.util.Vector3;

public final class UtilGL {
    private static final GLU glu = new GLU();

    public static void checkErrors(GL gl) throws GLException {
        int error;
        ArrayList<String> errors = new ArrayList<String>();
        while ((error = gl.glGetError()) != 0) {
            errors.add(new GLU().gluErrorString(error));
        }
        if (!errors.isEmpty()) {
            // empty if block
        }
    }

    public static void applyColor(GL gl, ColorRGB color) {
        gl.glColor3f(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static void applyColorWithAlpha(GL gl, ColorRGBA color) {
        gl.glColor4f(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static void enableBlend(GL gl, BlendMode blendMode) {
        gl.glEnable(3042);
        switch (blendMode) {
            case ALPHA_BLEND: {
                gl.glBlendFunc(770, 771);
                break;
            }
            case ADDITIVE: {
                gl.glBlendFunc(770, 1);
            }
        }
    }

    public static void disableBlend(GL gl) {
        gl.glDisable(3042);
    }

    public static void drawSquare(GL gl, float x, float y, float z, float size) {
        gl.glBegin(7);
        gl.glNormal3f(0.0f, 0.0f, 1.0f);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f(x - size, y - size, z);
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3f(x + size, y - size, z);
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3f(x + size, y + size, z);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3f(x - size, y + size, z);
        gl.glEnd();
    }

    public static void drawTexturedSquare(GL gl, Texture texture, float x, float y, float z, float size) {
        texture.bind(gl);
        UtilGL.drawSquare(gl, x, y, z, size);
        texture.unbind(gl);
    }

    public static PositionState getPositionState(GL gl) {
        return new PositionState(gl);
    }

    public static Vector3 getScreenPosition(GL gl, Vector3 worldPosition, Dimension screenSize) {
        PositionState positionState = new PositionState(gl, screenSize);
        return UtilGL.getScreenPosition(positionState, worldPosition);
    }

    public static Vector3 getScreenPosition(PositionState positionState, Vector3 worldPosition) {
        DoubleBuffer position = BufferUtil.newDoubleBuffer(3);
        glu.gluProject(worldPosition.x, worldPosition.y, worldPosition.z, positionState.modelView, positionState.projection, positionState.viewport, position);
        return new Vector3(position);
    }

    public static Vector3 getWorldPosition(GL gl, Vector3 screenPosition) {
        PositionState positionState = new PositionState(gl);
        return UtilGL.getWorldPosition(positionState, screenPosition);
    }

    public static Vector3 getWorldPosition(PositionState positionState, Vector3 screenPosition) {
        DoubleBuffer position = BufferUtil.newDoubleBuffer(3);
        glu.gluUnProject(screenPosition.x, screenPosition.y, screenPosition.z, positionState.modelView, positionState.projection, positionState.viewport, position);
        return new Vector3(position);
    }

    public static class PositionState {
        private final DoubleBuffer modelView = BufferUtil.newDoubleBuffer(16);
        private final DoubleBuffer projection = BufferUtil.newDoubleBuffer(16);
        private final IntBuffer viewport = BufferUtil.newIntBuffer(4);

        public PositionState(GL gl) {
            gl.glGetDoublev(2982, this.modelView);
            gl.glGetDoublev(2983, this.projection);
            gl.glGetIntegerv(2978, this.viewport);
        }

        public PositionState(GL gl, Dimension screenSize) {
            gl.glGetDoublev(2982, this.modelView);
            gl.glGetDoublev(2983, this.projection);
            this.viewport.put(0);
            this.viewport.put(0);
            this.viewport.put(screenSize.width);
            this.viewport.put(screenSize.height);
            this.viewport.flip();
        }
    }

    public static enum BlendMode {
        ALPHA_BLEND,
        ADDITIVE;

    }
}

