/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.levels;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lonelycoders.ufohippa.game.level.LevelDescriptor;

public class LevelManager {
    public static final File levelsPath = new File("levels");
    public static final String NEW_LEVELS = "Ufohippa 3";
    public static final File newLevelsPath = new File(levelsPath, "Ufohippa 3");
    public static final String OLD_LEVELS = "Old levels";
    public static final File oldLevelsPath = new File(levelsPath, "Old levels");
    public static final String RECEIVED_LEVELS = "Received";
    public static final File receivedLevelsPath = new File(levelsPath, "Received");
    public static final String CREATED_LEVELS = "Created";
    public static final File createdLevelsPath = new File(levelsPath, "Created");
    private final SortedSet<String> folders = new TreeSet<String>(new FolderComparator());
    private final Map<String, LevelCollection> levelCollections = new HashMap<String, LevelCollection>();
    private final List<Listener> listeners = new ArrayList<Listener>();

    public LevelManager() {
        this.refresh();
    }

    public Collection<String> getLevelFolders() {
        return Collections.unmodifiableCollection(this.folders);
    }

    public Collection<LevelDescriptor> getLevels(String folderName) {
        LevelCollection levelCollection = this.levelCollections.get(folderName);
        return Collections.unmodifiableCollection(levelCollection.levels);
    }

    public void refresh() {
        this.folders.clear();
        FileFilter foldersFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && !file.getName().equals(".svn");
            }
        };
        for (File folder : levelsPath.listFiles(foldersFilter)) {
            String folderName = folder.getName();
            this.folders.add(folderName);
            LevelCollection levelCollection = new LevelCollection();
            FileFilter levelFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return !file.isDirectory() && file.getName().endsWith(".level");
                }
            };
            for (File levelFile : folder.listFiles(levelFilter)) {
                levelCollection.addLevel(LevelManager.getLevel(levelFile));
            }
            TreeSet levels = new TreeSet();
            this.levelCollections.put(folderName, levelCollection);
        }
        for (Listener listener : this.listeners) {
            listener.levelsRefreshed();
        }
    }

    public LevelDescriptor getLevel(String name) {
        for (LevelCollection levelCollection : this.levelCollections.values()) {
            for (LevelDescriptor level : levelCollection.levels) {
                if (!level.getName().equals(name)) continue;
                return level;
            }
        }
        return null;
    }

    public static LevelDescriptor getLevel(File levelFile) {
        String folderName = levelFile.getParentFile().getName();
        String levelName = levelFile.getName().split(".level")[0];
        return new LevelDescriptor(folderName, levelName, levelFile);
    }

    public static boolean isOldLevel(LevelDescriptor levelDescriptor) {
        return levelDescriptor.getFolderName().equals(OLD_LEVELS);
    }

    public Collection<? extends LevelDescriptor> getAllLevels() {
        ArrayList<LevelDescriptor> allLevels = new ArrayList<LevelDescriptor>();
        for (String folder : this.folders) {
            for (LevelDescriptor level : this.levelCollections.get(folder).levels) {
                allLevels.add(level);
            }
        }
        return allLevels;
    }

    public void addRefreshListener(Listener listener) {
        this.listeners.add(listener);
    }

    private class FolderComparator
    implements Comparator<String> {
        private final Map<String, Integer> staticOrder = new HashMap<String, Integer>();

        private FolderComparator() {
            this.staticOrder.put(LevelManager.OLD_LEVELS, -1);
            this.staticOrder.put(LevelManager.NEW_LEVELS, -2);
        }

        @Override
        public int compare(String o1, String o2) {
            Integer rank2I;
            int rank2;
            Integer rank1I = this.staticOrder.get(o1);
            int rank1 = rank1I != null ? rank1I : 0;
            int delta = rank1 - (rank2 = (rank2I = this.staticOrder.get(o2)) != null ? rank2I : 0);
            if (delta != 0) {
                return delta;
            }
            return o1.compareTo(o2);
        }
    }

    public static interface Listener {
        public void levelsRefreshed();
    }

    private static class LevelCollection {
        private final SortedSet<LevelDescriptor> levels = new TreeSet<LevelDescriptor>();

        private LevelCollection() {
        }

        public void addLevel(LevelDescriptor levelDescriptor) {
            this.levels.add(levelDescriptor);
        }
    }
}

