/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.lobby.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lonelycoders.ufohippa.client.lobby.gui.ClientChangeListener;
import lonelycoders.ufohippa.client.lobby.gui.ClientSettingsManager;
import lonelycoders.ufohippa.client.lobby.gui.TitledPanel;
import lonelycoders.ufohippa.client.lobby.model.AllMatchSettings;
import lonelycoders.ufohippa.client.lobby.model.PlayerInfo;

public class AllPlayersPanel
extends TitledPanel {
    public AllPlayersPanel(ClientSettingsManager clientSettingsManager, int playersPerRow) {
        super("All players");
        this.setOpaque(false);
        final JPanel list = new JPanel(new GridLayout((16 + playersPerRow - 1) / playersPerRow, playersPerRow));
        list.setOpaque(false);
        list.add(new JLabel(" "));
        final AllMatchSettings.Listener listener = new AllMatchSettings.Listener(){

            @Override
            public void playersChanged(List<PlayerInfo> players) {
                list.removeAll();
                int i = 0;
                for (PlayerInfo player : players) {
                    JLabel label = new JLabel(player.getName());
                    label.setForeground(player.getColor().toAwtColor());
                    list.add(label);
                    ++i;
                }
                while (i < 16) {
                    list.add(new JLabel(" "));
                    ++i;
                }
                if (AllPlayersPanel.this.isDisplayable()) {
                    AllPlayersPanel.this.revalidate();
                    AllPlayersPanel.this.getParent().repaint();
                }
            }

            @Override
            public void levelsChanged(List<String> levels) {
            }

            @Override
            public void basicSettingsChanged(int playingTime, int aiPlayers, boolean bonusItems, boolean publicGame, boolean allowJoiningDuringGame) {
            }
        };
        clientSettingsManager.addClientChangeListener(new ClientChangeListener(){
            private AllMatchSettings settings;

            @Override
            public void clientChanged(AllMatchSettings settings) {
                if (this.settings != null) {
                    this.settings.removeListener(listener);
                }
                this.settings = settings;
                if (settings != null) {
                    settings.addListener(listener);
                } else {
                    listener.playersChanged(new ArrayList<PlayerInfo>());
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)list, "Center");
    }
}

