/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.lobby.gui;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lonelycoders.ufohippa.client.ApplicationFrame;
import lonelycoders.ufohippa.client.Client;
import lonelycoders.ufohippa.client.levels.LevelManager;
import lonelycoders.ufohippa.client.lobby.gui.AllPlayersPanel;
import lonelycoders.ufohippa.client.lobby.gui.ClientChangeListener;
import lonelycoders.ufohippa.client.lobby.gui.ClientSettingsManager;
import lonelycoders.ufohippa.client.lobby.gui.HostedGameSettingsPanel;
import lonelycoders.ufohippa.client.lobby.gui.LobbyMode;
import lonelycoders.ufohippa.client.lobby.gui.MessagePanel;
import lonelycoders.ufohippa.client.lobby.gui.PlayersPanel;
import lonelycoders.ufohippa.client.lobby.gui.SelectLevelsPanel;
import lonelycoders.ufohippa.client.lobby.model.AllMatchSettings;
import lonelycoders.ufohippa.client.lobby.model.PlayerSettingsModel;
import lonelycoders.ufohippa.client.sound.SoundManager;
import lonelycoders.ufohippa.client.states.ClientLobbyState;
import lonelycoders.ufohippa.game.level.LevelDescriptor;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.server.Server;
import lonelycoders.ufohippa.server.model.AllServerSettings;
import lonelycoders.ufohippa.server.model.PlayerInfo;

public class HostGamePanel
extends JPanel
implements LobbyMode,
ClientSettingsManager {
    private final Server server = new Server();
    private final PlayerSettingsModel playerSettings = new PlayerSettingsModel();
    private final Collection<ClientChangeListener> listeners = new HashSet<ClientChangeListener>();
    private final ApplicationFrame applicationFrame;
    private final SoundManager soundManager;
    private final LevelManager levelManager;
    private final Runnable backCommand;
    private final Object gameLock;
    private final MessagePanel messagePanel;
    private Client client;

    public HostGamePanel(final ApplicationFrame applicationFrame, Object gameLock, SoundManager soundManager, LevelManager levelManager, Runnable backCommand) {
        this.applicationFrame = applicationFrame;
        this.gameLock = gameLock;
        this.soundManager = soundManager;
        this.levelManager = levelManager;
        this.backCommand = backCommand;
        this.setOpaque(false);
        int MARGIN = 10;
        double[] columns = new double[]{MARGIN, -1.0, MARGIN};
        double[] rows = new double[]{MARGIN, -1.0, MARGIN, -2.0, MARGIN};
        TableLayout layout = new TableLayout(columns, rows);
        this.setLayout(layout);
        AllServerSettings allServerSettings = this.server.getAllServerSettings();
        double[] settingsColumns = new double[]{-2.0, -2.0, -1.0};
        double[] settingsRows = new double[]{-2.0, -2.0, -1.0};
        TableLayout settingsLayout = new TableLayout(settingsColumns, settingsRows);
        settingsLayout.setHGap(0);
        settingsLayout.setVGap(0);
        JPanel settingsPanel = new JPanel(settingsLayout);
        settingsPanel.setOpaque(false);
        PlayersPanel playerPanel = new PlayersPanel("Local players", this.playerSettings, false);
        settingsPanel.add((Component)playerPanel, "0, 0, f, f");
        HostedGameSettingsPanel gameSettingsPanel = new HostedGameSettingsPanel(allServerSettings);
        settingsPanel.add((Component)gameSettingsPanel, "1, 0, f, f");
        AllPlayersPanel allPlayersPanel = new AllPlayersPanel(this, 4);
        settingsPanel.add((Component)allPlayersPanel, "0, 1, 1, 1, f, f");
        MessagePanel.MessageSender messageSender = new MessagePanel.MessageSender(){

            @Override
            public void sendMessage(String message) {
                HostGamePanel.this.sendMessage(message);
            }
        };
        this.messagePanel = new MessagePanel(messageSender);
        settingsPanel.add((Component)this.messagePanel, "0, 2, 1, 2, f, f");
        SelectLevelsPanel selectLevelsPanel = new SelectLevelsPanel(allServerSettings, levelManager);
        settingsPanel.add((Component)selectLevelsPanel, "2, 0, 2, 2, f, f");
        this.add((Component)settingsPanel, "1, 1, f, f");
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        buttonsPanel.setOpaque(false);
        final JButton startButton = new JButton("Start game");
        startButton.setEnabled(false);
        buttonsPanel.add(startButton);
        allServerSettings.addListener(new AllServerSettings.Listener(){

            @Override
            public void basicSettingsChanged(int maxPlayers, int playingTime, int aiPlayers, boolean bonusItems, boolean publicGame, boolean allowJoiningDuringGame) {
            }

            @Override
            public void levelsChanged(List<LevelDescriptor> levels) {
                startButton.setEnabled(!levels.isEmpty());
            }

            @Override
            public void playersChanged(List<PlayerInfo> players) {
            }
        });
        JButton backButton = new JButton("Back to menu");
        buttonsPanel.add(backButton);
        startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HostGamePanel.this.server.startGame();
            }
        });
        backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(SwingUtilities.windowForComponent(HostGamePanel.this), "You have a server currently running.\nLeaving will close the server.", "Confirm close server", 2);
                if (result == 0) {
                    if (HostGamePanel.this.client != null) {
                        applicationFrame.unregisterClient(HostGamePanel.this.client);
                    }
                    HostGamePanel.this.server.close();
                    Logger.info("Leaving host game");
                    HostGamePanel.this.backCommand.run();
                } else {
                    Logger.info("Not leaving host game");
                }
            }
        });
        this.add((Component)buttonsPanel, "1, 3, c, c");
    }

    private void sendMessage(String message) {
        ClientLobbyState lobbyState = this.client.getManager().getLobbyState();
        lobbyState.sendMessage(message);
    }

    @Override
    public void activate() {
        Logger.info("Activating host game");
        try {
            this.server.start();
        }
        catch (RuntimeException e) {
            JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), "Unable to start server. Perhaps the port 13579 is already in use", "Failed to start server", 2);
            this.backCommand.run();
            return;
        }
        this.messagePanel.addMessage("Waiting for connections on port " + this.server.getLocalPort());
        this.client = new Client(this.soundManager, this.levelManager, "GUI client", this.gameLock, this.applicationFrame);
        this.client.getManager().getLobbyState().addMessageListener(new ClientLobbyState.MessageListener(){

            @Override
            public void messageReceived(String clientName, String message) {
                HostGamePanel.this.messagePanel.addMessage(clientName, message);
            }
        });
        this.applicationFrame.registerServer(this.server);
        this.applicationFrame.registerClient(this.client);
        try {
            this.client.connect(InetAddress.getLocalHost(), 13579);
        }
        catch (IOException e) {
            Logger.exception(e);
        }
        this.fireClientChanged();
        this.client.getManager().getLobbyState().addSettingsListener(new ClientLobbyState.SettingsListener(){

            @Override
            public void clientSettingsChanged(int playerCount, String[] playerNames, ColorRGB[] playerColors) {
                HostGamePanel.this.playerSettings.setPlayerCount(playerCount, false);
                for (int i = 0; i < playerCount; ++i) {
                    HostGamePanel.this.playerSettings.setPlayerName(i, playerNames[i], false);
                    HostGamePanel.this.playerSettings.setPlayerColor(i, playerColors[i], false);
                }
            }
        });
        this.playerSettings.addListener(new PlayerSettingsModel.Listener(){

            @Override
            public void playersChanged(int newPlayerCount, String[] newNames, ColorRGB[] newColors) {
                HostGamePanel.this.updateClientSettings();
            }
        });
    }

    private void fireClientChanged() {
        for (ClientChangeListener listener : this.listeners) {
            AllMatchSettings allMatchSettings = this.client == null ? null : this.client.getAllMatchSettings();
            listener.clientChanged(allMatchSettings);
        }
    }

    private void updateClientSettings() {
        ClientLobbyState lobbyState = this.client.getManager().getLobbyState();
        lobbyState.setClientSettings(this.playerSettings.getPlayerCount(), this.playerSettings.getPlayerNames(), this.playerSettings.getPlayerColors());
    }

    @Override
    public void addClientChangeListener(ClientChangeListener listener) {
        this.listeners.add(listener);
        AllMatchSettings allMatchSettings = this.client == null ? null : this.client.getAllMatchSettings();
        listener.clientChanged(allMatchSettings);
    }

    @Override
    public void removeClientChangeListener(ClientChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void reset() {
        this.messagePanel.reset();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(new Color(255, 255, 255, 127));
        Rectangle clip = g.getClipBounds();
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
    }
}

