/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.lobby.gui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.DefaultCaret;
import lonelycoders.ufohippa.client.lobby.gui.TitledPanel;

public class MessagePanel
extends TitledPanel {
    private final JTextArea text;

    public MessagePanel(final MessageSender messageSender) {
        super("Messages");
        this.setOpaque(false);
        double[] columns = new double[]{-1.0, -2.0};
        double[] rows = new double[]{-1.0, -2.0};
        TableLayout layout = new TableLayout(columns, rows);
        this.setLayout(layout);
        this.text = new JTextArea();
        this.text.setLineWrap(true);
        this.text.setEditable(false);
        this.text.setFont(this.text.getFont().deriveFont((float)this.text.getFont().getSize() * 0.8f));
        ((DefaultCaret)this.text.getCaret()).setUpdatePolicy(2);
        JScrollPane textScroll = new JScrollPane(this.text, 22, 31);
        textScroll.setPreferredSize(new Dimension(10, 10));
        this.add((Component)textScroll, "0, 0, 1, 0, f, f");
        final JTextField line = new JTextField();
        this.add((Component)line, "0, 1, f, c");
        final JButton send = new JButton("Send");
        this.add((Component)send, "1, 1, c, c");
        line.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                send.doClick();
            }
        });
        send.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                messageSender.sendMessage(line.getText());
                line.setText("");
            }
        });
    }

    public void addMessage(String message) {
        this.text.append(message + "\n");
    }

    public void addMessage(String prefix, String message) {
        this.addMessage("<" + prefix + "> " + message);
    }

    public void reset() {
        this.text.setText("");
    }

    public static interface MessageSender {
        public void sendMessage(String var1);
    }
}

