/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.lobby.gui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import lonelycoders.ufohippa.client.lobby.gui.ColorPanel;
import lonelycoders.ufohippa.client.lobby.gui.TitledPanel;
import lonelycoders.ufohippa.client.lobby.model.PlayerSettingsModel;
import lonelycoders.ufohippa.game.util.ColorRGB;

public class PlayersPanel
extends TitledPanel {
    public PlayersPanel(String title, PlayerSettingsModel playerSettings, boolean horizontal) {
        super(title);
        this.setOpaque(false);
        if (horizontal) {
            this.setLayout(new TableLayout(new double[]{5.0, 0.33, 5.0, 0.33, 5.0, 0.33, 5.0}, new double[]{0.0, -2.0, -2.0, 5.0}));
            this.add((Component)this.createPlayerCountPanel(playerSettings, horizontal), "1, 1, 5, 1");
            this.add((Component)this.createPlayerPanel(playerSettings, 0), "1, 2");
            this.add((Component)this.createPlayerPanel(playerSettings, 1), "3, 2");
            this.add((Component)this.createPlayerPanel(playerSettings, 2), "5, 2");
        } else {
            TableLayout layout = new TableLayout(new double[]{5.0, -2.0, 5.0}, new double[]{0.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0});
            this.setLayout(layout);
            this.add((Component)this.createPlayerCountPanel(playerSettings, horizontal), "1, 1, l, t");
            this.add((Component)this.createPlayerPanel(playerSettings, 0), "1, 3");
            this.add((Component)this.createPlayerPanel(playerSettings, 1), "1, 5");
            this.add((Component)this.createPlayerPanel(playerSettings, 2), "1, 7");
        }
    }

    private JPanel createPlayerCountPanel(final PlayerSettingsModel playerSettings, boolean horizontal) {
        int MARGIN = horizontal ? 5 : 0;
        TableLayout layout = new TableLayout(new double[]{-2.0, MARGIN, -2.0, MARGIN, -2.0, MARGIN, -2.0}, new double[]{-2.0});
        JPanel playerCountPanel = new JPanel(layout);
        playerCountPanel.setOpaque(false);
        ButtonGroup playerCount = new ButtonGroup();
        final JRadioButton playerCount1 = new JRadioButton("1");
        playerCount1.setOpaque(false);
        final JRadioButton playerCount2 = new JRadioButton("2");
        playerCount2.setOpaque(false);
        final JRadioButton playerCount3 = new JRadioButton("3");
        playerCount3.setOpaque(false);
        playerCount.add(playerCount1);
        playerCount.add(playerCount2);
        playerCount.add(playerCount3);
        playerCountPanel.add((Component)new JLabel("Players: "), "0, 0");
        playerCountPanel.add((Component)playerCount1, "2, 0");
        playerCountPanel.add((Component)playerCount2, "4, 0");
        playerCountPanel.add((Component)playerCount3, "6, 0");
        playerSettings.addListener(new PlayerSettingsModel.Listener(){

            @Override
            public void playersChanged(int newPlayerCount, String[] newNames, ColorRGB[] newColors) {
                switch (newPlayerCount) {
                    case 1: {
                        playerCount1.setSelected(true);
                        break;
                    }
                    case 2: {
                        playerCount2.setSelected(true);
                        break;
                    }
                    case 3: {
                        playerCount3.setSelected(true);
                    }
                }
            }
        });
        class CountActionListener
        implements ActionListener {
            private final int count;

            CountActionListener(int count) {
                this.count = count;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                playerSettings.setPlayerCount(this.count, true);
            }
        }
        playerCount1.addActionListener(new CountActionListener(1));
        playerCount2.addActionListener(new CountActionListener(2));
        playerCount3.addActionListener(new CountActionListener(3));
        return playerCountPanel;
    }

    private JPanel createPlayerPanel(final PlayerSettingsModel playerSettings, final int index) {
        final JPanel playerPanel = new JPanel(new TableLayout(new double[]{-2.0, 5.0, -2.0}, new double[]{-2.0, -2.0}));
        playerPanel.setOpaque(false);
        final JTextField nameField = new JTextField(10);
        final ColorPanel colorChooser = new ColorPanel();
        colorChooser.setBorder(nameField.getBorder());
        playerPanel.add((Component)new JLabel("Name:"), "0, 0");
        playerPanel.add((Component)nameField, "2, 0");
        playerPanel.add((Component)new JLabel("Color:"), "0, 1");
        playerPanel.add((Component)colorChooser, "2, 1");
        playerSettings.addListener(new PlayerSettingsModel.Listener(){

            @Override
            public void playersChanged(int newPlayerCount, String[] newNames, ColorRGB[] newColors) {
                playerPanel.setVisible(newPlayerCount > index);
                if (newPlayerCount > index) {
                    nameField.setText(newNames[index]);
                    colorChooser.setColor(newColors[index]);
                }
            }
        });
        nameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                playerSettings.setPlayerName(index, nameField.getText(), true);
            }
        });
        nameField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                playerSettings.setPlayerName(index, nameField.getText(), true);
            }
        });
        colorChooser.addListener(new ColorPanel.Listener(){

            @Override
            public void colorChanged(ColorRGB newColor) {
                playerSettings.setPlayerColor(index, newColor, true);
            }
        });
        return playerPanel;
    }
}

