/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.lobby.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import lonelycoders.ufohippa.client.levels.LevelManager;
import lonelycoders.ufohippa.client.lobby.gui.TitledPanel;
import lonelycoders.ufohippa.game.level.LevelDescriptor;
import lonelycoders.ufohippa.server.model.AllServerSettings;

public class SelectLevelsPanel
extends TitledPanel {
    private final AllServerSettings allServerSettings;

    public SelectLevelsPanel(AllServerSettings allServerSettings, final LevelManager levelManager) {
        super("Select levels");
        this.allServerSettings = allServerSettings;
        this.setOpaque(false);
        final JTree levels = new JTree();
        this.createModel(levels, levelManager);
        levelManager.addRefreshListener(new LevelManager.Listener(){

            @Override
            public void levelsRefreshed() {
                SelectLevelsPanel.this.createModel(levels, levelManager);
            }
        });
        levels.setCellRenderer(new CheckRenderer());
        levels.addMouseListener(new NodeSelectionListener(levels));
        levels.getSelectionModel().setSelectionMode(1);
        levels.setRootVisible(false);
        levels.setShowsRootHandles(true);
        levels.setToggleClickCount(0);
        this.setLayout(new BorderLayout());
        JScrollPane listScroll = new JScrollPane(levels);
        listScroll.setPreferredSize(new Dimension(200, 300));
        this.add((Component)listScroll, "Center");
    }

    private void createModel(JTree levels, LevelManager levelManager) {
        CheckNode root = new CheckNode("Root");
        for (String folderName : levelManager.getLevelFolders()) {
            CheckNode folderNode = new CheckNode(folderName);
            for (LevelDescriptor levelDescriptor : levelManager.getLevels(folderName)) {
                CheckNode levelNode = new CheckNode(levelDescriptor);
                folderNode.add(levelNode);
            }
            root.add(folderNode);
        }
        levels.setModel(new DefaultTreeModel(root));
        for (int row = 0; row < levels.getRowCount(); ++row) {
            levels.expandRow(row);
        }
    }

    private static enum SelectionMode {
        SINGLE_SELECTION,
        DIG_IN_SELECTION;

    }

    private class CheckNode
    extends DefaultMutableTreeNode {
        private final SelectionMode selectionMode;
        private boolean isSelected;

        public CheckNode(String folderName) {
            this(folderName, true, SelectionMode.DIG_IN_SELECTION);
        }

        public CheckNode(LevelDescriptor levelDescriptor) {
            this(levelDescriptor, false, SelectionMode.SINGLE_SELECTION);
        }

        public CheckNode(Object userObject, boolean allowsChildren, SelectionMode selectionMode) {
            super(userObject, allowsChildren);
            this.selectionMode = selectionMode;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
            if (this.userObject instanceof LevelDescriptor) {
                LevelDescriptor level = (LevelDescriptor)this.userObject;
                if (isSelected) {
                    SelectLevelsPanel.this.allServerSettings.addLevel(level);
                } else {
                    SelectLevelsPanel.this.allServerSettings.removeLevel(level);
                }
            }
            if (this.selectionMode == SelectionMode.DIG_IN_SELECTION && this.children != null) {
                for (Object child : this.children) {
                    CheckNode node = (CheckNode)child;
                    node.setSelected(isSelected);
                }
            }
        }

        public boolean isSelected() {
            return this.isSelected;
        }
    }

    private static class CheckRenderer
    extends JCheckBox
    implements TreeCellRenderer {
        public CheckRenderer() {
            this.setBackground(UIManager.getColor("Tree.textBackground"));
            this.setForeground(UIManager.getColor("Tree.textForeground"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            CheckNode checkNode = (CheckNode)value;
            this.setEnabled(tree.isEnabled());
            this.setSelected(checkNode.isSelected());
            this.setFont(tree.getFont());
            Object userObject = checkNode.getUserObject();
            String text = "";
            if (userObject instanceof String) {
                text = (String)userObject;
            }
            if (userObject instanceof LevelDescriptor) {
                text = ((LevelDescriptor)userObject).getName();
            }
            this.setText(text);
            return this;
        }
    }

    private static class NodeSelectionListener
    extends MouseAdapter {
        private final JTree tree;

        public NodeSelectionListener(JTree tree) {
            this.tree = tree;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int row = this.tree.getRowForLocation(e.getX(), e.getY());
            TreePath path = this.tree.getPathForRow(row);
            if (path != null) {
                CheckNode node;
                node.setSelected(!(node = (CheckNode)path.getLastPathComponent()).isSelected());
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(node);
                this.tree.revalidate();
                this.tree.repaint();
            }
        }
    }
}

